/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.db;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jodd.db.DbManager;
import jodd.db.oom.DbOomException;
import jodd.db.oom.DbOomQuery;
import jodd.db.oom.DbSqlGenerator;
import jodd.db.oom.sqlgen.DbSqlBuilder;
import jodd.db.oom.sqlgen.ParsedSql;
import jodd.db.querymap.QueryMap;
import jodd.paramo.MethodParameter;
import jodd.paramo.Paramo;
import jodd.proxetta.ProxyTargetInfo;

public class DbQueryBuilder {
    protected final QueryMap queryMap = DbManager.getInstance().getQueryMap();
    protected final Map<String, ParsedSql> parsedSqlMap = new HashMap<String, ParsedSql>();
    protected final Map<String, String[]> methodParamNames = new HashMap<String, String[]>();

    public DbOomQuery createAndPopulateDbQuery(ProxyTargetInfo proxyTargetInfo, String query) {
        if (query == null && (query = this.resolveQuery(proxyTargetInfo)) == null) {
            throw new DbOomException("Query not resolved.");
        }
        DbSqlGenerator dbSqlGenerator = (DbSqlGenerator)this.parsedSqlMap.get(query);
        if (dbSqlGenerator == null) {
            ParsedSql parsedSql = DbSqlBuilder.sql((String)query).parse();
            this.parsedSqlMap.put(query, parsedSql);
            dbSqlGenerator = parsedSql;
        }
        DbOomQuery dbOomQuery = DbOomQuery.query((DbSqlGenerator)dbSqlGenerator);
        String keyName = proxyTargetInfo.targetClass.getName() + "." + proxyTargetInfo.targetMethodName;
        String[] paramNames = this.methodParamNames.get(keyName);
        if (paramNames == null) {
            paramNames = this.resolveMethodParameterNames(proxyTargetInfo);
            this.methodParamNames.put(keyName, paramNames);
        }
        for (int i = 0; i < paramNames.length; ++i) {
            String paramName = paramNames[i];
            dbOomQuery.setObject(paramName, proxyTargetInfo.arguments[i]);
        }
        return dbOomQuery;
    }

    protected String[] resolveMethodParameterNames(ProxyTargetInfo proxyTargetInfo) {
        Method method;
        try {
            method = proxyTargetInfo.targetClass.getDeclaredMethod(proxyTargetInfo.targetMethodName, proxyTargetInfo.argumentsClasses);
        }
        catch (NoSuchMethodException ex) {
            throw new DbOomException((Throwable)ex);
        }
        MethodParameter[] methodParameters = Paramo.resolveParameters((AccessibleObject)method);
        String[] paramNames = new String[methodParameters.length];
        for (int i = 0; i < methodParameters.length; ++i) {
            MethodParameter methodParameter = methodParameters[i];
            paramNames[i] = methodParameter.getName();
        }
        return paramNames;
    }

    protected String resolveQuery(ProxyTargetInfo proxyTargetInfo) {
        String keyName = proxyTargetInfo.targetClass.getName() + "." + proxyTargetInfo.targetMethodName;
        String query = this.queryMap.getQuery(keyName);
        if (query != null) {
            return query;
        }
        keyName = proxyTargetInfo.targetClass.getSimpleName() + "." + proxyTargetInfo.targetMethodName;
        query = this.queryMap.getQuery(keyName);
        if (query != null) {
            return query;
        }
        keyName = proxyTargetInfo.targetMethodName;
        return this.queryMap.getQuery(keyName);
    }
}

