/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.crypt;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import jodd.joy.exception.AppException;
import jodd.util.Base64;
import jodd.util.StringUtil;

public class SymmetricEncryptor {
    protected final Cipher ecipher;
    protected final Cipher dcipher;
    protected final int iterationCount;
    protected static final byte[] defaultSalt = new byte[]{-70, -57, 23, 49, -66, 126, 115, -1};
    private static final String ALGORITHM = "PBEWithMD5AndTripleDES";

    public SymmetricEncryptor(String passPhrase) {
        this(passPhrase, defaultSalt, 19);
    }

    public SymmetricEncryptor(String passPhrase, byte[] salt, int iterationCount) {
        this.iterationCount = iterationCount;
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, iterationCount);
            SecretKey key = SecretKeyFactory.getInstance(ALGORITHM).generateSecret(keySpec);
            this.ecipher = Cipher.getInstance(key.getAlgorithm());
            this.dcipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.dcipher.init(2, (Key)key, paramSpec);
        }
        catch (Exception ex) {
            throw new AppException(ex);
        }
    }

    public String encrypt(String str) {
        try {
            byte[] utf8 = str.getBytes("UTF-8");
            byte[] enc = this.ecipher.doFinal(utf8);
            return Base64.encodeToString((byte[])enc);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public String decrypt(String str) {
        try {
            str = StringUtil.replaceChar((String)str, (char)' ', (char)'+');
            byte[] dec = Base64.decode((String)str);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, "UTF-8");
        }
        catch (Throwable ignore) {
            return null;
        }
    }
}

