/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.auth;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jodd.joy.crypt.Threefish;
import jodd.servlet.ServletUtil;
import jodd.util.Base64;
import jodd.util.StringUtil;

public class AuthUtil {
    public static final String AUTH_SESSION_NAME = "AUTH";
    public static final String AUTH_COOKIE_NAME = "JODD_JOY_REMEMBERME";
    private static final Threefish ENCRYPTOR = new Threefish(256);
    private static final char COOKIE_DELIMETER = '*';

    public static Object getNewUserSession(HttpServletRequest servletRequest) {
        Object newUserSession = servletRequest.getAttribute(AUTH_SESSION_NAME);
        servletRequest.removeAttribute(AUTH_SESSION_NAME);
        return newUserSession;
    }

    public static Object getUserSession(HttpSession httpSession) {
        if (httpSession == null) {
            return null;
        }
        return httpSession.getAttribute(AUTH_SESSION_NAME);
    }

    public static Object getUserSession(HttpServletRequest servletRequest) {
        return AuthUtil.getUserSession(servletRequest.getSession(false));
    }

    public static void closeUserSession(HttpSession httpSession) {
        if (httpSession != null) {
            httpSession.removeAttribute(AUTH_SESSION_NAME);
        }
    }

    public static void closeUserSession(HttpServletRequest servletRequest) {
        AuthUtil.closeUserSession(servletRequest.getSession(false));
    }

    public static void startUserSession(HttpSession httpSession, Object userSession) {
        httpSession.setAttribute(AUTH_SESSION_NAME, userSession);
    }

    public static void startUserSession(HttpServletRequest servletRequest, Object userSession) {
        HttpSession session = servletRequest.getSession(true);
        session.setAttribute(AUTH_SESSION_NAME, userSession);
    }

    public static String[] readAuthCookie(HttpServletRequest request) throws Exception {
        Cookie cookie = ServletUtil.getCookie((HttpServletRequest)request, (String)AUTH_COOKIE_NAME);
        if (cookie == null) {
            return null;
        }
        String[] values = StringUtil.splitc((String)cookie.getValue(), (char)'*');
        for (int i = 0; i < values.length; ++i) {
            byte[] decoded = Base64.decode((String)values[i]);
            values[i] = ENCRYPTOR.decryptString(decoded);
        }
        return values;
    }

    public static void storeAuthCookie(HttpServletResponse response, int cookieMaxAge, String ... values) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append('*');
            }
            byte[] encrypted = ENCRYPTOR.encryptString(values[i]);
            sb.append(Base64.encodeToString((byte[])encrypted));
        }
        Cookie cookie = new Cookie(AUTH_COOKIE_NAME, sb.toString());
        cookie.setMaxAge(cookieMaxAge);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    public static void removeAuthCookie(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        Cookie cookie = ServletUtil.getCookie((HttpServletRequest)servletRequest, (String)AUTH_COOKIE_NAME);
        if (cookie == null) {
            return;
        }
        cookie.setMaxAge(0);
        cookie.setPath("/");
        servletResponse.addCookie(cookie);
    }

    static {
        ENCRYPTOR.init("jodd#auth!enc*ss@ap", 1387839703876605061L, 413320216747L);
    }
}

