/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.jspp;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import jodd.io.FileUtil;
import jodd.joy.jspp.JsppException;
import jodd.servlet.HtmlTag;
import jodd.util.StringTemplateParser;
import jodd.util.StringUtil;

public class Jspp {
    protected String tagPrefix = "pp:";
    protected String macroExtension = ".jspf";
    protected File jsppMacroFolder;
    protected String macroPrefix = "${";
    protected String macroSuffix = "}";

    public String getTagPrefix() {
        return this.tagPrefix;
    }

    public void setTagPrefix(String tagPrefix) {
        this.tagPrefix = tagPrefix;
    }

    public String getMacroExtension() {
        return this.macroExtension;
    }

    public void setMacroExtension(String macroExtension) {
        this.macroExtension = macroExtension;
    }

    public File getJsppMacroFolder() {
        return this.jsppMacroFolder;
    }

    public void setJsppMacroFolder(File jsppMacroFolder) {
        this.jsppMacroFolder = jsppMacroFolder;
    }

    public String getMacroPrefix() {
        return this.macroPrefix;
    }

    public void setMacroPrefix(String macroPrefix) {
        this.macroPrefix = macroPrefix;
    }

    public String getMacroSuffix() {
        return this.macroSuffix;
    }

    public void setMacroSuffix(String macroSuffix) {
        this.macroSuffix = macroSuffix;
    }

    public String process(String input) {
        StringTemplateParser tagParser = this.createStringTemplateParser();
        return tagParser.parse(input, new StringTemplateParser.MacroResolver(){

            public String resolve(String macro) {
                HtmlTag htmlTag = new HtmlTag("<" + macro + "/>");
                String tagName = htmlTag.getTagName();
                String macroBody = Jspp.this.loadMacro(tagName);
                Map attributes = htmlTag.getAttributes();
                for (Map.Entry entry : attributes.entrySet()) {
                    String key = Jspp.this.macroPrefix + (String)entry.getKey() + Jspp.this.macroSuffix;
                    macroBody = StringUtil.replace((String)macroBody, (String)key, (String)((String)entry.getValue()));
                }
                return macroBody;
            }
        });
    }

    protected String loadMacro(String macroName) {
        String macroBody;
        File fileMacro = new File(this.jsppMacroFolder, macroName + this.macroExtension);
        try {
            macroBody = FileUtil.readString((File)fileMacro);
        }
        catch (IOException ioex) {
            throw new JsppException(ioex);
        }
        return macroBody;
    }

    protected StringTemplateParser createStringTemplateParser() {
        StringTemplateParser tagParser = new StringTemplateParser();
        tagParser.setMacroStart("<" + this.tagPrefix);
        tagParser.setMacroEnd("/>");
        tagParser.setEscapeChar('\u0000');
        return tagParser;
    }
}

