/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.db;

import java.util.List;
import jodd.db.oom.DbOomQuery;
import jodd.db.oom.DbSqlGenerator;
import jodd.db.oom.sqlgen.DbEntitySql;
import jodd.joy.db.DbIdGenerator;
import jodd.joy.db.Entity;
import jodd.petite.meta.PetiteBean;
import jodd.petite.meta.PetiteInject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PetiteBean
public class AppDao {
    private static final Logger log = LoggerFactory.getLogger(AppDao.class);
    @PetiteInject
    DbIdGenerator dbIdGenerator;
    protected boolean generatedKeys;

    public AppDao() {
        this.setGeneratedKeys(true);
    }

    public boolean isGeneratedKeys() {
        return this.generatedKeys;
    }

    public void setGeneratedKeys(boolean generatedKeys) {
        this.generatedKeys = generatedKeys;
        if (log.isDebugEnabled()) {
            if (generatedKeys) {
                log.debug("IDs are incremented in database");
            } else {
                log.debug("IDs are generated by DbIdGenerator");
            }
        }
    }

    public <E extends Entity> E store(E entity) {
        if (!entity.isPersistent()) {
            DbOomQuery q;
            if (this.generatedKeys) {
                q = DbOomQuery.query((DbSqlGenerator)DbEntitySql.insert(entity));
                q.setGeneratedKey();
                q.executeUpdate();
                long key = q.getGeneratedKey();
                entity.setEntityId(key);
            } else {
                long nextId = this.dbIdGenerator.nextId(entity);
                entity.setEntityId(nextId);
                q = DbOomQuery.query((DbSqlGenerator)DbEntitySql.insert(entity));
                q.executeUpdate();
            }
            q.close();
        } else {
            DbOomQuery.query((DbSqlGenerator)DbEntitySql.updateAll(entity)).executeUpdateAndClose();
        }
        return entity;
    }

    public <E extends Entity> void save(E entity) {
        DbOomQuery q = DbOomQuery.query((DbSqlGenerator)DbEntitySql.insert(entity));
        q.executeUpdateAndClose();
    }

    public <E extends Entity> E findById(Class<E> entityType, long id) {
        return (E)((Entity)DbOomQuery.query((DbSqlGenerator)DbEntitySql.findById(entityType, (Number)id)).findAndClose(new Class[]{entityType}));
    }

    public <E extends Entity> void updateProperty(E entity, String name, Object value) {
        DbOomQuery.query((DbSqlGenerator)DbEntitySql.updateColumn(entity, (String)name, (Object)value)).executeUpdateAndClose();
    }

    public <E extends Entity> E findById(E entity) {
        if (entity == null) {
            return null;
        }
        return (E)((Entity)DbOomQuery.query((DbSqlGenerator)DbEntitySql.findById(entity)).findAndClose(new Class[]{entity.getClass()}));
    }

    public <E extends Entity> E findOneByProperty(Class<E> entityType, String name, Object value) {
        return (E)((Entity)DbOomQuery.query((DbSqlGenerator)DbEntitySql.findByColumn(entityType, (String)name, (Object)value)).findAndClose(new Class[]{entityType}));
    }

    public <E extends Entity> E findOne(E criteria) {
        return (E)((Entity)DbOomQuery.query((DbSqlGenerator)DbEntitySql.find(criteria)).findAndClose(new Class[]{criteria.getClass()}));
    }

    public <E extends Entity> List<E> find(E criteria) {
        return DbOomQuery.query((DbSqlGenerator)DbEntitySql.find(criteria)).listAndClose(new Class[]{criteria.getClass()});
    }

    public void deleteById(Class entityType, long id) {
        DbOomQuery.query((DbSqlGenerator)DbEntitySql.deleteById((Object)entityType, (Number)id)).executeUpdateAndClose();
    }

    public void deleteById(Entity entity) {
        if (entity != null && entity.isPersistent()) {
            DbOomQuery.query((DbSqlGenerator)DbEntitySql.delete((Object)entity)).executeUpdateAndClose();
        }
    }

    public <E extends Entity> long count(Class<E> entityType) {
        return DbOomQuery.query((DbSqlGenerator)DbEntitySql.count(entityType)).executeCountAndClose();
    }

    public <E extends Entity> List<E> findRelated(Class<E> target, Entity source) {
        return DbOomQuery.query((DbSqlGenerator)DbEntitySql.findForeign(target, (Object)source)).listAndClose();
    }

    public <E extends Entity> List<E> list(Class<E> target) {
        return DbOomQuery.query((DbSqlGenerator)DbEntitySql.from(target)).list(new Class[]{target});
    }
}

