/*
 * Decompiled with CFR 0.152.
 */
package jodd.joy.i18n;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import jodd.joy.i18n.LocalizationUtil;
import jodd.util.HtmlEncoder;
import jodd.util.StringUtil;

public class TextTag
extends SimpleTagSupport
implements DynamicAttributes {
    private static final String UNKNOWN_PREFIX = "???";
    private static final String UNKNOWN_SUFFIX = "\u00bf\u00bf\u00bf";
    private static final String KEY_ATTR_NAME = "key";
    protected String key;
    protected boolean defaultOnly;
    private List<String[]> params = new ArrayList<String[]>();

    public void setKey(String key) {
        this.key = key;
    }

    public void setDefaultOnly(String defaultOnly) {
        this.defaultOnly = Boolean.parseBoolean(defaultOnly);
    }

    public void setDynamicAttribute(String uri, String localName, Object value) {
        this.params.add(new String[]{localName, StringUtil.toSafeString((Object)value)});
    }

    public void doTag() throws JspException {
        String message;
        PageContext pageContext = (PageContext)this.getJspContext();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        this.key = this.key.trim();
        if (StringUtil.isEmpty((String)this.key)) {
            return;
        }
        String string = message = this.defaultOnly ? LocalizationUtil.findDefaultMessage(request, this.key) : LocalizationUtil.findMessage(request, this.key);
        if (message == null) {
            message = UNKNOWN_PREFIX + this.key + UNKNOWN_SUFFIX;
        } else {
            for (String[] param : this.params) {
                String paramValue;
                String paramName = param[0];
                String value = paramValue = param[1];
                if (paramName.startsWith(KEY_ATTR_NAME)) {
                    String string2 = value = this.defaultOnly ? LocalizationUtil.findDefaultMessage(request, paramValue) : LocalizationUtil.findMessage(request, paramValue);
                    if (value == null) {
                        value = UNKNOWN_PREFIX + paramValue + UNKNOWN_SUFFIX;
                    }
                }
                message = StringUtil.replace((String)message, (String)('{' + paramName + '}'), (String)value);
            }
        }
        JspWriter out = pageContext.getOut();
        try {
            out.print(HtmlEncoder.text((String)message));
        }
        catch (IOException ioex) {
            // empty catch block
        }
    }
}

