/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import jodd.http.Buffer;
import jodd.http.Cookie;
import jodd.http.HttpBase;
import jodd.http.HttpConnection;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpException;
import jodd.http.HttpMultiMap;
import jodd.http.HttpProgressListener;
import jodd.http.HttpResponse;
import jodd.http.HttpStatus;
import jodd.http.HttpUtil;
import jodd.net.HttpMethod;
import jodd.util.Base64;
import jodd.util.StringUtil;

public class HttpRequest
extends HttpBase<HttpRequest> {
    protected String protocol = "http";
    protected String host = "localhost";
    protected int port = -1;
    protected String method = "GET";
    protected String path = "/";
    protected HttpMultiMap<String> query;
    protected String queryEncoding = HttpBase.Defaults.queryEncoding;
    private boolean trustAllCertificates;
    private boolean verifyHttpsHost = true;
    protected int timeout = -1;
    protected int connectTimeout = -1;
    protected boolean followRedirects = false;
    protected int maxRedirects = 50;
    protected HttpConnection httpConnection;
    protected HttpConnectionProvider httpConnectionProvider;

    public HttpRequest() {
        this.initRequest();
    }

    protected void initRequest() {
        this.connectionKeepAlive(false);
    }

    public String host() {
        return this.host;
    }

    public HttpRequest host(String host) {
        this.host = host;
        if (this.headers.contains("Host")) {
            this.headerOverwrite("Host", host);
        }
        return this;
    }

    public String protocol() {
        return this.protocol;
    }

    public HttpRequest protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public int port() {
        if (this.port == -1) {
            if (this.protocol == null) {
                return 80;
            }
            if (this.protocol.equalsIgnoreCase("https")) {
                return 443;
            }
            return 80;
        }
        return this.port;
    }

    public HttpRequest port(int port) {
        this.port = port;
        return this;
    }

    public HttpRequest set(String destination) {
        int ndx = (destination = destination.trim()).indexOf(32);
        if (ndx != -1) {
            String method = destination.substring(0, ndx).toUpperCase();
            try {
                HttpMethod httpMethod = HttpMethod.valueOf((String)method);
                this.method = httpMethod.name();
                destination = destination.substring(ndx + 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((ndx = destination.indexOf("://")) != -1) {
            this.protocol = destination.substring(0, ndx);
            destination = destination.substring(ndx + 3);
        }
        if ((ndx = destination.indexOf(47)) == -1) {
            ndx = destination.length();
        }
        if (ndx != 0) {
            String hostToSet = destination.substring(0, ndx);
            destination = destination.substring(ndx);
            ndx = hostToSet.indexOf(58);
            if (ndx == -1) {
                this.port = -1;
            } else {
                this.port = Integer.parseInt(hostToSet.substring(ndx + 1));
                hostToSet = hostToSet.substring(0, ndx);
            }
            this.host(hostToSet);
        }
        this.path(destination);
        return this;
    }

    public static HttpRequest create(String method, String destination) {
        return new HttpRequest().method(method.toUpperCase()).set(destination);
    }

    public static HttpRequest connect(String destination) {
        return new HttpRequest().method(HttpMethod.CONNECT).set(destination);
    }

    public static HttpRequest get(String destination) {
        return new HttpRequest().method(HttpMethod.GET).set(destination);
    }

    public static HttpRequest post(String destination) {
        return new HttpRequest().method(HttpMethod.POST).set(destination);
    }

    public static HttpRequest put(String destination) {
        return new HttpRequest().method(HttpMethod.PUT).set(destination);
    }

    public static HttpRequest patch(String destination) {
        return new HttpRequest().method(HttpMethod.PATCH).set(destination);
    }

    public static HttpRequest delete(String destination) {
        return new HttpRequest().method(HttpMethod.DELETE).set(destination);
    }

    public static HttpRequest head(String destination) {
        return new HttpRequest().method(HttpMethod.HEAD).set(destination);
    }

    public static HttpRequest trace(String destination) {
        return new HttpRequest().method(HttpMethod.TRACE).set(destination);
    }

    public static HttpRequest options(String destination) {
        return new HttpRequest().method(HttpMethod.OPTIONS).set(destination);
    }

    public String method() {
        return this.method;
    }

    public HttpRequest method(String method) {
        this.method = method.toUpperCase();
        return this;
    }

    public HttpRequest method(HttpMethod httpMethod) {
        this.method = httpMethod.name();
        return this;
    }

    public String path() {
        return this.path;
    }

    public HttpRequest path(String path) {
        int ndx;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((ndx = path.indexOf(63)) != -1) {
            String queryString = path.substring(ndx + 1);
            path = path.substring(0, ndx);
            this.query = HttpUtil.parseQuery(queryString, true);
        } else {
            this.query = HttpMultiMap.newCaseInsensitiveMap();
        }
        this.path = path;
        return this;
    }

    public HttpRequest multipart(boolean multipart) {
        this.multipart = multipart;
        return this;
    }

    public HttpRequest cookies(Cookie ... cookies) {
        if (cookies.length == 0) {
            return this;
        }
        StringBuilder cookieString = new StringBuilder();
        boolean first = true;
        for (Cookie cookie : cookies) {
            Integer maxAge = cookie.getMaxAge();
            if (maxAge != null && maxAge == 0) continue;
            if (!first) {
                cookieString.append("; ");
            }
            first = false;
            cookieString.append(cookie.getName());
            cookieString.append('=');
            cookieString.append(cookie.getValue());
        }
        this.headerOverwrite("cookie", cookieString.toString());
        return this;
    }

    public HttpRequest query(String name, String value) {
        this.query.add(name, value);
        return this;
    }

    public HttpRequest query(String name1, Object value1, Object ... parameters) {
        this.query(name1, value1 == null ? null : value1.toString());
        for (int i = 0; i < parameters.length; i += 2) {
            String name = parameters[i].toString();
            String value = parameters[i + 1].toString();
            this.query.add(name, value);
        }
        return this;
    }

    public HttpRequest query(Map<String, String> queryMap) {
        for (Map.Entry<String, String> entry : queryMap.entrySet()) {
            this.query.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpMultiMap<String> query() {
        return this.query;
    }

    public HttpRequest clearQueries() {
        this.query.clear();
        return this;
    }

    public HttpRequest queryRemove(String name) {
        this.query.remove(name);
        return this;
    }

    public HttpRequest queryString(String queryString) {
        return this.queryString(queryString, true);
    }

    public HttpRequest queryString(String queryString, boolean decode) {
        this.query = HttpUtil.parseQuery(queryString, decode);
        return this;
    }

    public String queryString() {
        if (this.query == null) {
            return "";
        }
        return HttpUtil.buildQuery(this.query, this.queryEncoding);
    }

    public HttpRequest queryEncoding(String encoding) {
        this.queryEncoding = encoding;
        return this;
    }

    public String url() {
        String queryString;
        StringBuilder url = new StringBuilder();
        url.append(this.hostUrl());
        if (this.path != null) {
            url.append(this.path);
        }
        if (StringUtil.isNotBlank((CharSequence)(queryString = this.queryString()))) {
            url.append('?');
            url.append(queryString);
        }
        return url.toString();
    }

    public String hostUrl() {
        StringBuilder url = new StringBuilder();
        if (this.protocol != null) {
            url.append(this.protocol);
            url.append("://");
        }
        if (this.host != null) {
            url.append(this.host);
        }
        if (this.port != -1) {
            url.append(':');
            url.append(this.port);
        }
        return url.toString();
    }

    public HttpRequest basicAuthentication(String username, String password) {
        if (username != null && password != null) {
            String data = username.concat(":").concat(password);
            String base64 = Base64.encodeToString((String)data);
            this.headerOverwrite("Authorization", "Basic " + base64);
        }
        return this;
    }

    public HttpRequest tokenAuthentication(String token) {
        if (token != null) {
            this.headerOverwrite("Authorization", "Bearer " + token);
        }
        return this;
    }

    public HttpRequest trustAllCerts(boolean trust) {
        this.trustAllCertificates = trust;
        return this;
    }

    public boolean trustAllCertificates() {
        return this.trustAllCertificates;
    }

    public HttpRequest verifyHttpsHost(boolean verifyHttpsHost) {
        this.verifyHttpsHost = verifyHttpsHost;
        return this;
    }

    public boolean verifyHttpsHost() {
        return this.verifyHttpsHost;
    }

    public HttpRequest setHostHeader() {
        String hostPort = this.host;
        if (this.port != -1) {
            hostPort = hostPort + ":" + this.port;
        }
        this.headerOverwrite("Host", hostPort);
        return this;
    }

    public HttpRequest monitor(HttpProgressListener httpProgressListener) {
        this.httpProgressListener = httpProgressListener;
        return this;
    }

    public HttpRequest timeout(int milliseconds) {
        this.timeout = milliseconds;
        return this;
    }

    public int timeout() {
        return this.timeout;
    }

    public HttpRequest connectionTimeout(int milliseconds) {
        this.connectTimeout = milliseconds;
        return this;
    }

    public int connectionTimeout() {
        return this.connectTimeout;
    }

    public HttpRequest followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public HttpRequest maxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return this;
    }

    public int maxRedirects() {
        return this.maxRedirects;
    }

    public HttpRequest withConnectionProvider(HttpConnectionProvider httpConnectionProvider) {
        this.httpConnectionProvider = httpConnectionProvider;
        return this;
    }

    public HttpConnectionProvider connectionProvider() {
        return this.httpConnectionProvider;
    }

    public HttpConnection connection() {
        return this.httpConnection;
    }

    public HttpRequest open() {
        if (this.httpConnectionProvider == null) {
            return this.open(HttpConnectionProvider.get());
        }
        return this.open(this.httpConnectionProvider);
    }

    public HttpRequest open(HttpConnectionProvider httpConnectionProvider) {
        if (this.httpConnection != null) {
            throw new HttpException("Connection already opened");
        }
        try {
            this.httpConnectionProvider = httpConnectionProvider;
            this.httpConnection = httpConnectionProvider.createHttpConnection(this);
        }
        catch (IOException ioex) {
            throw new HttpException("Can't connect to: " + this.url(), ioex);
        }
        return this;
    }

    public HttpRequest open(HttpConnection httpConnection) {
        if (this.httpConnection != null) {
            throw new HttpException("Connection already opened");
        }
        this.httpConnection = httpConnection;
        this.httpConnectionProvider = null;
        return this;
    }

    public HttpRequest keepAlive(HttpResponse httpResponse, boolean doContinue) {
        boolean keepAlive = httpResponse.isConnectionPersistent();
        if (keepAlive) {
            HttpConnection previousConnection = httpResponse.getHttpRequest().httpConnection;
            if (previousConnection != null) {
                this.httpConnection = previousConnection;
                this.httpConnectionProvider = httpResponse.getHttpRequest().connectionProvider();
            }
        } else {
            httpResponse.close();
            keepAlive = true;
        }
        if (!doContinue) {
            keepAlive = false;
        }
        this.connectionKeepAlive(keepAlive);
        if (this.httpConnection == null) {
            this.open(httpResponse.getHttpRequest().connectionProvider());
        }
        return this;
    }

    public HttpResponse send() {
        if (!this.followRedirects) {
            return this._send();
        }
        for (int redirects = this.maxRedirects; redirects > 0; --redirects) {
            HttpResponse httpResponse = this._send();
            int statusCode = httpResponse.statusCode();
            if (HttpStatus.isRedirect(statusCode)) {
                this._reset();
                this.set(httpResponse.location());
                continue;
            }
            return httpResponse;
        }
        throw new HttpException("Max number of redirects exceeded: " + this.maxRedirects);
    }

    private void _reset() {
        this.headers.remove("Host");
    }

    private HttpResponse _send() {
        HttpResponse httpResponse;
        if (this.httpConnection == null) {
            this.open();
        }
        try {
            OutputStream outputStream = this.httpConnection.getOutputStream();
            this.sendTo(outputStream);
            InputStream inputStream = this.httpConnection.getInputStream();
            httpResponse = HttpResponse.readFrom(inputStream);
            httpResponse.assignHttpRequest(this);
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
        boolean keepAlive = httpResponse.isConnectionPersistent();
        if (!keepAlive) {
            this.httpConnection.close();
            this.httpConnection = null;
        }
        return httpResponse;
    }

    @Override
    protected Buffer buffer(boolean fullRequest) {
        if (this.header("Host") == null) {
            this.setHostHeader();
        }
        Buffer formBuffer = this.formBuffer();
        String queryString = this.queryString();
        if (this.header("User-Agent") == null) {
            this.header("User-Agent", HttpBase.Defaults.userAgent);
        }
        if (this.method.equals("POST") && this.contentLength() == null) {
            this.contentLength(0);
        }
        Buffer request = new Buffer();
        request.append(this.method).append(" ").append(this.path);
        if (this.query != null && !this.query.isEmpty()) {
            request.append('?');
            request.append(queryString);
        }
        request.append(" ").append(this.httpVersion).append("\r\n");
        this.populateHeaderAndBody(request, formBuffer, fullRequest);
        return request;
    }

    public static HttpRequest readFrom(InputStream in) {
        return HttpRequest.readFrom(in, StandardCharsets.ISO_8859_1.name());
    }

    public static HttpRequest readFrom(InputStream in, String encoding) {
        String line;
        BufferedReader reader;
        try {
            reader = new BufferedReader(new InputStreamReader(in, encoding));
        }
        catch (UnsupportedEncodingException uneex) {
            return null;
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.headers.clear();
        try {
            line = reader.readLine();
        }
        catch (IOException ioex) {
            throw new HttpException(ioex);
        }
        if (!StringUtil.isBlank((CharSequence)line)) {
            String[] s = StringUtil.splitc((String)line, (char)' ');
            httpRequest.method(s[0]);
            httpRequest.path(s[1]);
            httpRequest.httpVersion(s[2]);
            httpRequest.readHeaders(reader);
            httpRequest.readBody(reader);
        }
        return httpRequest;
    }

    public HttpRequest contentTypeJson() {
        return (HttpRequest)this.contentType("application/json");
    }

    public HttpRequest acceptJson() {
        return (HttpRequest)this.accept("application/json");
    }

    public CompletableFuture<HttpResponse> sendAsync() {
        return CompletableFuture.supplyAsync(this::send);
    }

    public <R> R sendAndReceive(Function<HttpResponse, R> responseHandler) {
        return responseHandler.apply(this.send());
    }

    public void sendAndReceive(Consumer<HttpResponse> responseHandler) {
        responseHandler.accept(this.send());
    }
}

