/*
 * Decompiled with CFR 0.152.
 */
package jodd.http.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import jodd.http.HttpException;
import jodd.http.ProxyInfo;

public class Socks4ProxySocketFactory
extends SocketFactory {
    private final ProxyInfo proxy;

    public Socks4ProxySocketFactory(ProxyInfo proxy) {
        this.proxy = proxy;
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.createSocks4ProxySocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.createSocks4ProxySocket(host, port);
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocks4ProxySocket(host.getHostAddress(), port);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.createSocks4ProxySocket(address.getHostAddress(), port);
    }

    private Socket createSocks4ProxySocket(String host, int port) {
        Socket socket = null;
        String proxyHost = this.proxy.getProxyAddress();
        int proxyPort = this.proxy.getProxyPort();
        String user = this.proxy.getProxyUsername();
        try {
            int i;
            socket = new Socket(proxyHost, proxyPort);
            InputStream in = socket.getInputStream();
            OutputStream out = socket.getOutputStream();
            socket.setTcpNoDelay(true);
            byte[] buf = new byte[1024];
            int index = 0;
            buf[index++] = 4;
            buf[index++] = 1;
            buf[index++] = (byte)(port >>> 8);
            buf[index++] = (byte)(port & 0xFF);
            InetAddress addr = InetAddress.getByName(host);
            byte[] byteAddress = addr.getAddress();
            for (int i2 = 0; i2 < byteAddress.length; ++i2) {
                buf[index++] = byteAddress[i2];
            }
            if (user != null) {
                System.arraycopy(user.getBytes(), 0, buf, index, user.length());
                index += user.length();
            }
            buf[index++] = 0;
            out.write(buf, 0, index);
            int len = 6;
            for (int s = 0; s < len; s += i) {
                i = in.read(buf, s, len - s);
                if (i > 0) continue;
                throw new HttpException((Object)ProxyInfo.ProxyType.SOCKS4, "stream is closed");
            }
            if (buf[0] != 0) {
                throw new HttpException((Object)ProxyInfo.ProxyType.SOCKS4, "proxy returned VN " + buf[0]);
            }
            if (buf[1] != 90) {
                try {
                    socket.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw new HttpException((Object)ProxyInfo.ProxyType.SOCKS4, "proxy returned CD " + buf[1]);
            }
            byte[] temp = new byte[2];
            in.read(temp, 0, 2);
            return socket;
        }
        catch (RuntimeException rtex) {
            this.closeSocket(socket);
            throw rtex;
        }
        catch (Exception ex) {
            this.closeSocket(socket);
            throw new HttpException((Object)ProxyInfo.ProxyType.SOCKS4, ex.toString(), ex);
        }
    }

    private void closeSocket(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

