/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import jodd.datetime.TimeUtil;
import jodd.http.HttpException;
import jodd.http.HttpParamsMap;
import jodd.http.HttpUtil;
import jodd.io.FastCharArrayWriter;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.upload.MultipartStreamParser;
import jodd.util.MimeTypes;
import jodd.util.RandomStringUtil;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpBase<T> {
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_HOST = "Host";
    public static final String HEADER_ETAG = "ETag";
    protected String httpVersion = "HTTP/1.1";
    protected Map<String, String> headers = new LinkedHashMap<String, String>();
    protected HttpParamsMap form;
    protected String body;

    public String httpVersion() {
        return this.httpVersion;
    }

    public T httpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
        return (T)this;
    }

    public String header(String name) {
        String key = name.trim().toLowerCase();
        return this.headers.get(key);
    }

    public void removeHeader(String name) {
        String key = name.trim().toLowerCase();
        this.headers.remove(key);
    }

    public T header(String name, String value) {
        String key = name.trim().toLowerCase();
        this.headers.put(key, value.trim());
        return (T)this;
    }

    public T header(String name, int value) {
        this.header(name, String.valueOf(value));
        return (T)this;
    }

    public T header(String name, long millis) {
        this.header(name, TimeUtil.formatHttpDate((long)millis));
        return (T)this;
    }

    public String contentType() {
        return this.header(HEADER_CONTENT_TYPE);
    }

    public T contentType(String contentType) {
        this.header(HEADER_CONTENT_TYPE, contentType);
        return (T)this;
    }

    public String contentLength() {
        return this.header(HEADER_CONTENT_LENGTH);
    }

    public T contentLength(int value) {
        this.header(HEADER_CONTENT_LENGTH, value);
        return (T)this;
    }

    public String contentEncoding() {
        return this.header(HEADER_CONTENT_ENCODING);
    }

    public String acceptEncoding() {
        return this.header(HEADER_ACCEPT_ENCODING);
    }

    public T acceptEncoding(String encodings) {
        this.header(HEADER_ACCEPT_ENCODING, encodings);
        return (T)this;
    }

    protected void initForm() {
        if (this.form == null) {
            this.form = new HttpParamsMap();
        }
    }

    public T form(String name, Object value) {
        this.initForm();
        this.form.put(name, value);
        return (T)this;
    }

    public T form(String name, Object value, Object ... parameters) {
        this.initForm();
        if (this.form == null) {
            this.form = new HttpParamsMap();
        }
        this.form.put(name, value);
        for (int i = 0; i < parameters.length; i += 2) {
            name = parameters[i].toString();
            this.form.put(name, parameters[i + 1]);
        }
        return (T)this;
    }

    public Map<String, Object> form() {
        return this.form;
    }

    public String body() {
        return this.body;
    }

    public T body(String body) {
        this.body = body;
        this.form = null;
        this.contentLength(body.length());
        return (T)this;
    }

    protected boolean isFormMultipart() {
        for (Object o : this.form.values()) {
            Class<?> type = o.getClass();
            if (type.equals(String.class) || type.equals(String[].class)) continue;
            return true;
        }
        return false;
    }

    protected String formString() {
        if (this.form == null || this.form.isEmpty()) {
            return "";
        }
        if (!this.isFormMultipart()) {
            String queryString = HttpUtil.buildQuery(this.form);
            this.contentType("application/x-www-form-urlencoded");
            this.contentLength(queryString.length());
            return queryString;
        }
        String boundary = StringUtil.repeat((char)'-', (int)10) + RandomStringUtil.randomAlphaNumeric((int)10);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.form.entrySet()) {
            sb.append("--");
            sb.append(boundary);
            sb.append("\r\n");
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            Class<?> type = value.getClass();
            if (type == String.class) {
                sb.append("Content-Disposition: form-data; name=\"").append(name).append('\"').append("\r\n");
                sb.append("\r\n");
                sb.append(value);
            } else if (type == String[].class) {
                String[] array;
                for (String v : array = (String[])value) {
                    sb.append("Content-Disposition: form-data; name=\"").append(name).append('\"').append("\r\n");
                    sb.append("\r\n");
                    sb.append(v);
                }
            } else if (type == File.class) {
                File file = (File)value;
                String fileName = FileNameUtil.getName((String)file.getName());
                sb.append("Content-Disposition: form-data; name=\"").append(name);
                sb.append("\"; filename=\"").append(fileName).append('\"').append("\r\n");
                String mimeType = MimeTypes.getMimeType((String)FileNameUtil.getExtension((String)fileName));
                sb.append("Content-Type: ").append(mimeType).append("\r\n");
                sb.append("Content-Transfer-Encoding: binary").append("\r\n");
                sb.append("\r\n");
                try {
                    char[] chars = FileUtil.readChars((File)file, (String)"ISO-8859-1");
                    sb.append(chars);
                }
                catch (IOException ioex) {
                    throw new HttpException(ioex);
                }
            } else {
                throw new HttpException("Unsupported parameter type: " + type.getName());
            }
            sb.append("\r\n");
        }
        sb.append("--").append(boundary).append("--");
        this.contentType("multipart/form-data; boundary=" + boundary);
        this.contentLength(sb.length());
        return sb.toString();
    }

    public byte[] toByteArray() {
        try {
            return this.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ignore) {
            return null;
        }
    }

    public void sendTo(OutputStream out) throws IOException {
        byte[] bytes = this.toByteArray();
        out.write(bytes);
        out.flush();
    }

    protected void readHeaders(BufferedReader reader) {
        block3: {
            String line;
            while (true) {
                try {
                    line = reader.readLine();
                }
                catch (IOException ioex) {
                    throw new HttpException(ioex);
                }
                if (StringUtil.isBlank((String)line)) break block3;
                int ndx = line.indexOf(58);
                if (ndx == -1) break;
                this.header(line.substring(0, ndx), line.substring(ndx + 1));
            }
            throw new HttpException("Invalid header: " + line);
        }
    }

    protected void readBody(BufferedReader reader) {
        String transferEncoding;
        FastCharArrayWriter fastCharArrayWriter;
        String bodyString = null;
        String contentLen = this.contentLength();
        if (contentLen != null) {
            int len = Integer.parseInt(contentLen);
            fastCharArrayWriter = new FastCharArrayWriter(len);
            try {
                StreamUtil.copy((Reader)reader, (Writer)fastCharArrayWriter, (int)len);
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
            bodyString = fastCharArrayWriter.toString();
        }
        if ((transferEncoding = this.header("Transfer-Encoding")) != null && transferEncoding.equalsIgnoreCase("chunked")) {
            fastCharArrayWriter = new FastCharArrayWriter();
            try {
                String line;
                while (!StringUtil.isBlank((String)(line = reader.readLine()))) {
                    int len = Integer.parseInt(line, 16);
                    if (len == 0) continue;
                    StreamUtil.copy((Reader)reader, (Writer)fastCharArrayWriter, (int)len);
                    reader.readLine();
                }
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
            bodyString = fastCharArrayWriter.toString();
        }
        if (bodyString == null) {
            if (this.httpVersion().equals("HTTP/1.0")) {
                fastCharArrayWriter = new FastCharArrayWriter();
                try {
                    StreamUtil.copy((Reader)reader, (Writer)fastCharArrayWriter);
                }
                catch (IOException ioex) {
                    throw new HttpException(ioex);
                }
                bodyString = fastCharArrayWriter.toString();
            } else {
                this.body = null;
                return;
            }
        }
        this.body = bodyString;
        String contentType = this.contentType();
        contentType = contentType == null ? "" : contentType.toLowerCase();
        if (contentType.equals("application/x-www-form-urlencoded")) {
            this.form = HttpUtil.parseQuery(bodyString, true);
            return;
        }
        if (contentType.startsWith("multipart/form-data")) {
            String[] values;
            this.form = new HttpParamsMap();
            MultipartStreamParser multipartParser = new MultipartStreamParser();
            try {
                byte[] bodyBytes = bodyString.getBytes("ISO-8859-1");
                ByteArrayInputStream bin = new ByteArrayInputStream(bodyBytes);
                multipartParser.parseRequestStream((InputStream)bin, "ISO-8859-1");
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
            for (String paramName : multipartParser.getParameterNames()) {
                values = multipartParser.getParameterValues(paramName);
                if (values.length == 1) {
                    this.form.put(paramName, (Object)values[0]);
                    continue;
                }
                this.form.put(paramName, (Object)values);
            }
            for (String paramName : multipartParser.getFileParameterNames()) {
                values = multipartParser.getFiles(paramName);
                if (values.length == 1) {
                    this.form.put(paramName, (Object)values[0]);
                    continue;
                }
                this.form.put(paramName, (Object)values);
            }
            return;
        }
        this.form = null;
    }
}

