/*
 * Decompiled with CFR 0.152.
 */
package jodd.http;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jodd.util.ArraysUtil;
import jodd.util.KeyValue;
import jodd.util.URLCoder;
import jodd.util.URLDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpParams {
    protected final Map<String, Object> params;
    protected boolean hasFiles;

    public HttpParams(Map<String, Object> params) {
        this.params = params;
    }

    public HttpParams() {
        this.params = new LinkedHashMap<String, Object>();
    }

    public HttpParams(String query) {
        this(query, false);
    }

    public HttpParams(String query, boolean decode) {
        this.params = new LinkedHashMap<String, Object>();
        this.addParameters(query, decode);
    }

    public int getParamsCount() {
        return this.params.size();
    }

    public boolean hasFiles() {
        return this.hasFiles;
    }

    public Object getParameter(String key) {
        return this.params.get(key);
    }

    public void addParameter(String key, Object value) {
        Object existing = this.params.get(key);
        if (existing != null) {
            Class<?> type = existing.getClass();
            if (type == String.class) {
                value = new String[]{existing.toString(), value.toString()};
            } else if (type == String[].class) {
                value = ArraysUtil.append((String[])((String[])existing), (String)value.toString());
            } else {
                this.hasFiles = true;
            }
        }
        this.setParameter(key, value);
    }

    public void setParameter(String name, Object value) {
        Class<?> type = value.getClass();
        if (type != String.class && type != String[].class) {
            this.hasFiles = true;
        }
        this.params.put(name, value);
    }

    public void addParameters(String query, boolean decode) {
        int ndx2 = 0;
        while (true) {
            int ndx;
            if ((ndx = query.indexOf(61, ndx2)) == -1) {
                if (ndx2 >= query.length()) break;
                this.params.put(query.substring(ndx2), null);
                break;
            }
            String name = query.substring(ndx2, ndx);
            if (decode) {
                name = URLDecoder.decode((String)name);
            }
            if ((ndx = query.indexOf(38, ndx2 = ndx + 1)) == -1) {
                ndx = query.length();
            }
            Object[] value = query.substring(ndx2, ndx);
            if (decode) {
                value = URLDecoder.decode((String)value);
            }
            Object[] newValue = value;
            Object existing = this.params.get(name);
            if (existing != null) {
                newValue = existing.getClass().isArray() ? ArraysUtil.append((Object[])((String[])existing), (Object)newValue) : new String[]{existing.toString(), value};
            }
            this.params.put(name, newValue);
            ndx2 = ndx + 1;
        }
    }

    public void removeParameter(String key) {
        this.params.remove(key);
    }

    public Iterator<KeyValue<String, Object>> iterate() {
        final Iterator<Map.Entry<String, Object>> iterator = this.params.entrySet().iterator();
        final KeyValue keyValue = new KeyValue();
        return new Iterator<KeyValue<String, Object>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public KeyValue<String, Object> next() {
                Map.Entry entry = (Map.Entry)iterator.next();
                keyValue.setKey(entry.getKey());
                keyValue.setValue(entry.getValue());
                return keyValue;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append('&');
            }
            String key = URLCoder.encodeQuery((String)entry.getKey());
            Object value = entry.getValue();
            if (value != null) {
                Class<?> type = value.getClass();
                if (type == String[].class) {
                    Object[] array = (Object[])value;
                    for (int i = 0; i < array.length; ++i) {
                        if (i != 0) {
                            sb.append('&');
                        }
                        Object o = array[i];
                        sb.append(key);
                        sb.append('=');
                        sb.append(URLCoder.encodeQuery((String)o.toString()));
                    }
                    continue;
                }
                sb.append(key);
                sb.append('=');
                sb.append(URLCoder.encodeQuery((String)value.toString()));
                continue;
            }
            sb.append(key);
        }
        return sb.toString();
    }
}

