/*
 * Decompiled with CFR 0.152.
 */
package jodd.htmlstapler;

import jodd.htmlstapler.BundleAction;
import jodd.htmlstapler.HtmlStaplerBundlesManager;
import jodd.lagarto.Tag;
import jodd.lagarto.TagAdapter;
import jodd.lagarto.TagVisitor;
import jodd.util.CharArraySequence;
import jodd.util.CharSequenceUtil;
import jodd.util.Util;

public class HtmlStaplerTagAdapter
extends TagAdapter {
    protected final HtmlStaplerBundlesManager bundlesManager;
    protected final BundleAction jsBundleAction;
    protected final BundleAction cssBundleAction;
    protected boolean insideConditionalComment;
    private static final CharSequence T_LINK = CharArraySequence.of((char[])new char[]{'l', 'i', 'n', 'k'});

    public HtmlStaplerTagAdapter(HtmlStaplerBundlesManager bundlesManager, String servletPath, TagVisitor target) {
        super(target);
        this.bundlesManager = bundlesManager;
        this.jsBundleAction = bundlesManager.start(servletPath, "js");
        this.cssBundleAction = bundlesManager.start(servletPath, "css");
        this.insideConditionalComment = false;
    }

    public void script(Tag tag, CharSequence body) {
        if (!this.insideConditionalComment) {
            String src = Util.toString((Object)tag.getAttributeValue((CharSequence)"src"));
            if (src == null) {
                super.script(tag, body);
                return;
            }
            if (this.jsBundleAction.acceptLink(src)) {
                String link = this.jsBundleAction.processLink(src);
                if (link != null) {
                    tag.setAttributeValue((CharSequence)"src", (CharSequence)link);
                    super.script(tag, body);
                }
                return;
            }
        }
        super.script(tag, body);
    }

    public void tag(Tag tag) {
        String href;
        String media;
        CharSequence type;
        if (!this.insideConditionalComment && tag.nameEquals(T_LINK) && (type = tag.getAttributeValue((CharSequence)"type")) != null && CharSequenceUtil.equalsIgnoreCase((CharSequence)type, (CharSequence)"text/css") && ((media = Util.toString((Object)tag.getAttributeValue((CharSequence)"media"))) == null || media.contains("screen")) && this.cssBundleAction.acceptLink(href = Util.toString((Object)tag.getAttributeValue((CharSequence)"href")))) {
            String link = this.cssBundleAction.processLink(href);
            if (link != null) {
                tag.setAttribute((CharSequence)"href", (CharSequence)link);
                super.tag(tag);
            }
            return;
        }
        super.tag(tag);
    }

    public void condComment(CharSequence expression, boolean isStartingTag, boolean isHidden, boolean isHiddenEndTag) {
        this.insideConditionalComment = isStartingTag;
        super.condComment(expression, isStartingTag, isHidden, isHiddenEndTag);
    }

    public void end() {
        this.jsBundleAction.end();
        this.cssBundleAction.end();
        super.end();
    }

    public char[] postProcess(char[] content) {
        content = this.jsBundleAction.replaceBundleId(content);
        content = this.cssBundleAction.replaceBundleId(content);
        return content;
    }
}

