/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.querymap;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import jodd.db.querymap.QueryMap;
import jodd.exception.UncheckedException;
import jodd.props.Props;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbPropsQueryMap
implements QueryMap {
    private static final Logger log = LoggerFactory.getLogger(DbPropsQueryMap.class);
    protected final Pattern pattern;
    protected Props props;

    public DbPropsQueryMap(Pattern pattern) {
        this.pattern = pattern;
        this.reload();
    }

    public DbPropsQueryMap() {
        this(Pattern.compile(".*.(sql|oom).prop(s|erties)"));
    }

    public Props props() {
        return this.props;
    }

    @Override
    public void reload() {
        this.props = new Props();
        try {
            this.loadFromClasspath(this.props, this.pattern);
        }
        catch (IOException e) {
            log.error("Unable to laod", (Throwable)e);
        }
    }

    @Override
    public int size() {
        return this.props.countTotalProperties();
    }

    @Override
    public String getQuery(String key) {
        return this.props.getValue(key);
    }

    private void loadFromClasspath(Props props, Pattern pattern) throws IOException {
        try (ScanResult scanResult = new ClassGraph().acceptPaths(new String[0]).scan();){
            scanResult.getResourcesMatchingPattern(pattern).forEachByteArrayThrowingIOException((res, content) -> {
                String usedEncoding = "UTF-8";
                if (StringUtil.endsWithIgnoreCase((String)res.getPath(), (String)".properties")) {
                    usedEncoding = StandardCharsets.ISO_8859_1.name();
                }
                String encoding = usedEncoding;
                String str = new String(content, encoding);
                UncheckedException.runAndWrapException(() -> props.load(str));
            });
        }
    }
}

