/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen.chunks;

import jodd.bean.BeanUtil;
import jodd.db.DbOom;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.sqlgen.chunks.SqlChunk;
import jodd.util.StringUtil;

public class UpdateSetChunk
extends SqlChunk {
    private static final String SET = "set ";
    protected final Object data;
    protected final String tableRef;
    protected final int includeColumns;
    protected final boolean isUpdateablePrimaryKey;

    public UpdateSetChunk(DbOom dbOom, String tableRef, Object data, int includeColumns) {
        super(dbOom.entityManager(), 6);
        this.tableRef = tableRef;
        this.data = data;
        this.includeColumns = includeColumns;
        this.isUpdateablePrimaryKey = dbOom.config().isUpdateablePrimaryKey();
    }

    @Override
    public void process(StringBuilder out) {
        if (this.isPreviousChunkOfType(2)) {
            this.appendMissingSpace(out);
        }
        DbEntityDescriptor ded = this.tableRef != null ? this.lookupTableRef(this.tableRef) : this.lookupType(UpdateSetChunk.resolveClass(this.data));
        out.append(SET);
        DbEntityColumnDescriptor[] decList = ded.getColumnDescriptors();
        String typeName = StringUtil.uncapitalize((String)ded.getEntityName());
        int size = 0;
        for (DbEntityColumnDescriptor dec : decList) {
            if (dec.isId() && !this.isUpdateablePrimaryKey) continue;
            String property = dec.getPropertyName();
            Object value = BeanUtil.declared.getProperty(this.data, property);
            if (this.includeColumns == 1 && this.isEmptyColumnValue(dec, value)) continue;
            if (size > 0) {
                out.append(',').append(' ');
            }
            ++size;
            out.append(dec.getColumnNameForQuery()).append('=');
            String propertyName = typeName + '.' + property;
            this.defineParameter(out, propertyName, value, dec);
        }
        if (size > 0) {
            out.append(' ');
        }
    }
}

