/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.jtx;

import jodd.db.DbSession;
import jodd.db.connection.ConnectionProvider;
import jodd.db.jtx.JtxDbUtil;
import jodd.jtx.JtxException;
import jodd.jtx.JtxResourceManager;
import jodd.jtx.JtxTransactionMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbJtxResourceManager
implements JtxResourceManager<DbSession> {
    private static final Logger log = LoggerFactory.getLogger(DbJtxResourceManager.class);
    protected final ConnectionProvider connectionProvider;

    public DbJtxResourceManager(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public Class<DbSession> getResourceType() {
        return DbSession.class;
    }

    @Override
    public DbSession beginTransaction(JtxTransactionMode jtxMode, boolean active) {
        DbSession session = new DbSession(this.connectionProvider);
        if (active) {
            log.debug("begin jtx");
            session.beginTransaction(JtxDbUtil.convertToDbMode(jtxMode));
        }
        return session;
    }

    @Override
    public void commitTransaction(DbSession resource) {
        if (resource.isTransactionActive()) {
            log.debug("commit jtx");
            resource.commitTransaction();
        }
        resource.closeSession();
    }

    @Override
    public void rollbackTransaction(DbSession resource) {
        try {
            if (resource.isTransactionActive()) {
                log.debug("rollback tx");
                resource.rollbackTransaction();
            }
        }
        catch (Exception ex) {
            throw new JtxException(ex);
        }
        finally {
            resource.closeSession();
        }
    }

    @Override
    public void close() {
        this.connectionProvider.close();
    }
}

