/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.util.Objects;

public class DbTransactionMode {
    public static final int ISOLATION_DEFAULT = -1;
    public static final int ISOLATION_NONE = 0;
    public static final int ISOLATION_READ_UNCOMMITTED = 1;
    public static final int ISOLATION_READ_COMMITTED = 2;
    public static final int ISOLATION_REPEATABLE_READ = 4;
    public static final int ISOLATION_SERIALIZABLE = 8;
    private final int isolation;
    public static final boolean READ_ONLY = true;
    public static final boolean READ_WRITE = false;
    private final boolean readOnlyMode;
    public static final DbTransactionMode READ_ONLY_TX = new DbTransactionMode(-1, true);
    public static final DbTransactionMode READ_WRITE_TX = new DbTransactionMode(-1, false);

    public int getIsolation() {
        return this.isolation;
    }

    public boolean isReadOnly() {
        return this.readOnlyMode;
    }

    public DbTransactionMode(int isolation, boolean readOnlyMode) {
        this.isolation = isolation;
        this.readOnlyMode = readOnlyMode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DbTransactionMode mode = (DbTransactionMode)object;
        return mode.getIsolation() == this.isolation && mode.isReadOnly() == this.readOnlyMode;
    }

    public int hashCode() {
        return Objects.hash(this.readOnlyMode, this.isolation);
    }
}

