/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import jodd.util.HashCode;

public class JulianDate
implements Serializable,
Cloneable {
    public static final JulianDate JD_1970 = new JulianDate(2440587, 0.5);
    public static final JulianDate JD_2001 = new JulianDate(2451910, 0.5);
    protected int integer;
    protected double fraction;

    public static JulianDate of(double value) {
        return new JulianDate(value);
    }

    public static JulianDate of(LocalDateTime localDateTime) {
        return JulianDate.of(localDateTime.getYear(), localDateTime.getMonth().getValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano() / 1000000);
    }

    public static JulianDate of(LocalDate localDate) {
        return JulianDate.of(localDate.getYear(), localDate.getMonth().getValue(), localDate.getDayOfMonth(), 0, 0, 0, 0);
    }

    public static JulianDate of(long milliseconds) {
        int integer = (int)(milliseconds / 86400000L);
        double fraction = (double)(milliseconds % 86400000L) / 8.64E7;
        return new JulianDate(integer += JulianDate.JD_1970.integer, fraction += JulianDate.JD_1970.fraction);
    }

    public static JulianDate of(int i, double f) {
        return new JulianDate(i, f);
    }

    public static JulianDate of(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        int im0;
        int iy0;
        double frac;
        if (month > 12 || month < -12) {
            int delta = --month / 12;
            year += delta;
            month -= delta * 12;
            ++month;
        }
        if (month < 0) {
            --year;
            month += 12;
        }
        if ((frac = (double)hour / 24.0 + (double)minute / 1440.0 + (double)second / 86400.0 + (double)millisecond / 8.64E7) < 0.0) {
            int delta = (int)(-frac) + 1;
            frac += (double)delta;
            day -= delta;
        }
        double gyr = (double)year + 0.01 * (double)month + 1.0E-4 * ((double)day + frac) + 1.0E-9;
        if (month <= 2) {
            iy0 = year - 1;
            im0 = month + 12;
        } else {
            iy0 = year;
            im0 = month;
        }
        int ia = iy0 / 100;
        int ib = 2 - ia + (ia >> 2);
        int jd = year <= 0 ? (int)(365.25 * (double)iy0 - 0.75) + (int)(30.6001 * (double)(im0 + 1)) + day + 1720994 : (int)(365.25 * (double)iy0) + (int)(30.6001 * (double)(im0 + 1)) + day + 1720994;
        if (gyr >= 1582.1015) {
            jd += ib;
        }
        return new JulianDate(jd, frac + 0.5);
    }

    public int getInteger() {
        return this.integer;
    }

    public double getFraction() {
        return this.fraction;
    }

    public int getSignificantFraction() {
        return (int)(this.fraction * 1.0E8);
    }

    public int getJulianDayNumber() {
        if (this.fraction >= 0.5) {
            return this.integer + 1;
        }
        return this.integer;
    }

    public JulianDate(double jd) {
        this.integer = (int)jd;
        this.fraction = jd - (double)this.integer;
    }

    public JulianDate(int i, double f) {
        this.set(i, f);
    }

    public JulianDate(BigDecimal bd) {
        double d = bd.doubleValue();
        this.integer = (int)d;
        this.fraction = bd.subtract(new BigDecimal(this.integer)).doubleValue();
    }

    public double doubleValue() {
        return (double)this.integer + this.fraction;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.integer).add(new BigDecimal(this.fraction));
    }

    public String toString() {
        String s = Double.toString(this.fraction);
        int i = s.indexOf(46);
        s = s.substring(i);
        return this.integer + s;
    }

    public long toMilliseconds() {
        double then = (this.fraction - JulianDate.JD_1970.fraction) * 8.64E7;
        return (long)(then += (then += (double)((long)(this.integer - JulianDate.JD_1970.integer) * 86400000L)) > 0.0 ? 1.0E-6 : -1.0E-6);
    }

    public LocalDateTime toLocalDateTime() {
        int ka = (int)(this.fraction + 0.5);
        int jd = this.integer + ka;
        double frac = this.fraction + 0.5 - (double)ka + 1.0E-10;
        ka = jd;
        if (jd >= 2299161) {
            int ialp = (int)(((double)jd - 1867216.25) / 36524.25);
            ka = jd + 1 + ialp - (ialp >> 2);
        }
        int kb = ka + 1524;
        int kc = (int)(((double)kb - 122.1) / 365.25);
        int kd = (int)((double)kc * 365.25);
        int ke = (int)((double)(kb - kd) / 30.6001);
        int day = kb - kd - (int)((double)ke * 30.6001);
        int month = ke > 13 ? ke - 13 : ke - 1;
        if (month == 2 && day > 28) {
            day = 29;
        }
        int year = month == 2 && day == 29 && ke == 3 ? kc - 4716 : (month > 2 ? kc - 4716 : kc - 4715);
        int time_year = year;
        int time_month = month;
        int time_day = day;
        double d_hour = frac * 24.0;
        int time_hour = (int)d_hour;
        double d_minute = (d_hour - (double)time_hour) * 60.0;
        int time_minute = (int)d_minute;
        double d_second = (d_minute - (double)time_minute) * 60.0;
        int time_second = (int)d_second;
        double d_millis = (d_second - (double)time_second) * 1000.0;
        int time_millisecond = (int)((d_millis * 10.0 + 0.5) / 10.0);
        return LocalDateTime.of(time_year, time_month, time_day, time_hour, time_minute, time_second, time_millisecond * 1000000);
    }

    public JulianDate add(JulianDate jds) {
        int i = this.integer + jds.integer;
        double f = this.fraction + jds.fraction;
        return new JulianDate(i, f);
    }

    public JulianDate add(double delta) {
        return new JulianDate(this.integer, this.fraction + delta);
    }

    public JulianDate sub(JulianDate jds) {
        int i = this.integer - jds.integer;
        double f = this.fraction - jds.fraction;
        return new JulianDate(i, f);
    }

    public JulianDate sub(double delta) {
        return new JulianDate(this.integer, this.fraction - delta);
    }

    private void set(int i, double f) {
        this.integer = i;
        int fi = (int)f;
        f -= (double)fi;
        this.integer += fi;
        if (f < 0.0) {
            f += 1.0;
            --this.integer;
        }
        this.fraction = f;
    }

    public int daysBetween(JulianDate otherDate) {
        int difference = this.daysSpan(otherDate);
        return difference >= 0 ? difference : -difference;
    }

    public int daysSpan(JulianDate otherDate) {
        int now = this.getJulianDayNumber();
        int then = otherDate.getJulianDayNumber();
        return now - then;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JulianDate stamp = (JulianDate)object;
        return stamp.integer == this.integer && Double.compare(stamp.fraction, this.fraction) == 0;
    }

    public int hashCode() {
        return HashCode.create().hash(this.integer).hash(this.fraction).get();
    }

    protected JulianDate clone() {
        return new JulianDate(this.integer, this.fraction);
    }

    public JulianDate getReducedJulianDate() {
        return new JulianDate(this.integer - 2400000, this.fraction);
    }

    public JulianDate getModifiedJulianDate() {
        return new JulianDate(this.integer - 2400000, this.fraction - 0.5);
    }

    public JulianDate getTruncatedJulianDate() {
        return new JulianDate(this.integer - 2440000, this.fraction - 0.5);
    }
}

