/*
 * Decompiled with CFR 0.152.
 */
package jodd.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JavaBridge {
    private static final String RESOURCE = JavaBridge.class.getName().replace('.', '/') + ".class";

    public static URL[] getURLs(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            return urlClassLoader.getURLs();
        }
        URL url = JavaBridge.currentModuleURL();
        if (url == null) {
            return new URL[0];
        }
        return new URL[]{url};
    }

    private static URL currentModuleURL() {
        URL url = JavaBridge.class.getClassLoader().getResource(RESOURCE);
        if (url == null) {
            return null;
        }
        String urlString = url.toString();
        int ndx = urlString.indexOf(RESOURCE);
        urlString = urlString.substring(0, ndx) + urlString.substring(ndx + RESOURCE.length());
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException ignore) {
            return null;
        }
    }
}

