/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import jodd.core.JoddCore;
import jodd.io.FastCharArrayWriter;
import jodd.io.FileUtilParams;
import jodd.io.StreamUtil;
import jodd.io.UnicodeInputStream;
import jodd.util.SystemUtil;
import jodd.util.URLDecoder;

public class FileUtil {
    private static final String MSG_NOT_A_DIRECTORY = "Not a directory: ";
    private static final String MSG_CANT_CREATE = "Can't create: ";
    private static final String MSG_NOT_FOUND = "Not found: ";
    private static final String MSG_NOT_A_FILE = "Not a file: ";
    private static final String MSG_ALREADY_EXISTS = "Already exists: ";
    private static final String MSG_UNABLE_TO_DELETE = "Unable to delete: ";

    private static File file(String fileName) {
        return new File(fileName);
    }

    private static File file(File parent, String fileName) {
        return new File(parent, fileName);
    }

    public static boolean equals(String file1, String file2) {
        return FileUtil.equals(FileUtil.file(file1), FileUtil.file(file2));
    }

    public static boolean equals(File file1, File file2) {
        try {
            file1 = file1.getCanonicalFile();
            file2 = file2.getCanonicalFile();
        }
        catch (IOException ignore) {
            return false;
        }
        return file1.equals(file2);
    }

    public static File toFile(URL url) {
        String fileName = FileUtil.toFileName(url);
        if (fileName == null) {
            return null;
        }
        return FileUtil.file(fileName);
    }

    public static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static String toFileName(URL url) {
        if (url == null || !url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        return URLDecoder.decode(filename, JoddCore.encoding);
    }

    public static File toContainerFile(URL url) {
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            return FileUtil.toFile(url);
        }
        String path = url.getPath();
        return new File(URI.create(path.substring(0, path.lastIndexOf("!/"))));
    }

    public static void mkdirs(String dirs) throws IOException {
        FileUtil.mkdirs(FileUtil.file(dirs));
    }

    public static void mkdirs(File dirs) throws IOException {
        if (dirs.exists()) {
            if (!dirs.isDirectory()) {
                throw new IOException(MSG_NOT_A_DIRECTORY + dirs);
            }
            return;
        }
        if (!dirs.mkdirs()) {
            throw new IOException(MSG_CANT_CREATE + dirs);
        }
    }

    public static void mkdir(String dir) throws IOException {
        FileUtil.mkdir(FileUtil.file(dir));
    }

    public static void mkdir(File dir) throws IOException {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException(MSG_NOT_A_DIRECTORY + dir);
            }
            return;
        }
        if (!dir.mkdir()) {
            throw new IOException(MSG_CANT_CREATE + dir);
        }
    }

    public static void touch(String file) throws IOException {
        FileUtil.touch(FileUtil.file(file));
    }

    public static void touch(File file) throws IOException {
        if (!file.exists()) {
            StreamUtil.close(new FileOutputStream(file));
        }
        file.setLastModified(System.currentTimeMillis());
    }

    public static FileUtilParams cloneParams() {
        try {
            return JoddCore.fileUtilParams.clone();
        }
        catch (CloneNotSupportedException ignore) {
            return null;
        }
    }

    public static FileUtilParams params() {
        return new FileUtilParams();
    }

    public static void copyFile(String src, String dest) throws IOException {
        FileUtil.copyFile(FileUtil.file(src), FileUtil.file(dest), JoddCore.fileUtilParams);
    }

    public static void copyFile(String src, String dest, FileUtilParams params) throws IOException {
        FileUtil.copyFile(FileUtil.file(src), FileUtil.file(dest), params);
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileUtil.copyFile(src, dest, JoddCore.fileUtilParams);
    }

    public static void copyFile(File src, File dest, FileUtilParams params) throws IOException {
        FileUtil.checkFileCopy(src, dest, params);
        FileUtil.doCopyFile(src, dest, params);
    }

    private static void checkFileCopy(File src, File dest, FileUtilParams params) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException(MSG_NOT_FOUND + src);
        }
        if (!src.isFile()) {
            throw new IOException(MSG_NOT_A_FILE + src);
        }
        if (FileUtil.equals(src, dest)) {
            throw new IOException("Files '" + src + "' and '" + dest + "' are equal");
        }
        File destParent = dest.getParentFile();
        if (destParent != null && !destParent.exists()) {
            if (!params.createDirs) {
                throw new IOException(MSG_NOT_FOUND + destParent);
            }
            if (!destParent.mkdirs()) {
                throw new IOException(MSG_CANT_CREATE + destParent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File src, File dest, FileUtilParams params) throws IOException {
        if (dest.exists()) {
            if (dest.isDirectory()) {
                throw new IOException("Destination '" + dest + "' is a directory");
            }
            if (!params.overwrite) {
                throw new IOException(MSG_ALREADY_EXISTS + dest);
            }
        }
        FileInputStream input = new FileInputStream(src);
        try {
            FileOutputStream output = new FileOutputStream(dest);
            try {
                StreamUtil.copy((InputStream)input, (OutputStream)output);
            }
            finally {
                StreamUtil.close(output);
            }
        }
        finally {
            StreamUtil.close(input);
        }
        if (src.length() != dest.length()) {
            throw new IOException("Copy file failed of '" + src + "' to '" + dest + "' due to different sizes");
        }
        if (params.preserveDate) {
            dest.setLastModified(src.lastModified());
        }
    }

    public static File copyFileToDir(String src, String destDir) throws IOException {
        return FileUtil.copyFileToDir(FileUtil.file(src), FileUtil.file(destDir), JoddCore.fileUtilParams);
    }

    public static File copyFileToDir(String src, String destDir, FileUtilParams params) throws IOException {
        return FileUtil.copyFileToDir(FileUtil.file(src), FileUtil.file(destDir), params);
    }

    public static File copyFileToDir(File src, File destDir) throws IOException {
        return FileUtil.copyFileToDir(src, destDir, JoddCore.fileUtilParams);
    }

    public static File copyFileToDir(File src, File destDir, FileUtilParams params) throws IOException {
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IOException(MSG_NOT_A_DIRECTORY + destDir);
        }
        File dest = FileUtil.file(destDir, src.getName());
        FileUtil.copyFile(src, dest, params);
        return dest;
    }

    public static void copyDir(String srcDir, String destDir) throws IOException {
        FileUtil.copyDir(FileUtil.file(srcDir), FileUtil.file(destDir), JoddCore.fileUtilParams);
    }

    public static void copyDir(String srcDir, String destDir, FileUtilParams params) throws IOException {
        FileUtil.copyDir(FileUtil.file(srcDir), FileUtil.file(destDir), params);
    }

    public static void copyDir(File srcDir, File destDir) throws IOException {
        FileUtil.copyDir(srcDir, destDir, JoddCore.fileUtilParams);
    }

    public static void copyDir(File srcDir, File destDir, FileUtilParams params) throws IOException {
        FileUtil.checkDirCopy(srcDir, destDir);
        FileUtil.doCopyDirectory(srcDir, destDir, params);
    }

    private static void checkDirCopy(File srcDir, File destDir) throws IOException {
        if (!srcDir.exists()) {
            throw new FileNotFoundException(MSG_NOT_FOUND + srcDir);
        }
        if (!srcDir.isDirectory()) {
            throw new IOException(MSG_NOT_A_DIRECTORY + srcDir);
        }
        if (FileUtil.equals(srcDir, destDir)) {
            throw new IOException("Source '" + srcDir + "' and destination '" + destDir + "' are equal");
        }
    }

    private static void doCopyDirectory(File srcDir, File destDir, FileUtilParams params) throws IOException {
        File[] files;
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException(MSG_NOT_A_DIRECTORY + destDir);
            }
        } else {
            if (!params.createDirs) {
                throw new IOException(MSG_NOT_FOUND + destDir);
            }
            if (!destDir.mkdirs()) {
                throw new IOException(MSG_CANT_CREATE + destDir);
            }
            if (params.preserveDate) {
                destDir.setLastModified(srcDir.lastModified());
            }
        }
        if ((files = srcDir.listFiles()) == null) {
            throw new IOException("Failed to list contents of: " + srcDir);
        }
        IOException exception = null;
        for (File file : files) {
            File destFile = FileUtil.file(destDir, file.getName());
            try {
                if (file.isDirectory()) {
                    if (!params.recursive) continue;
                    FileUtil.doCopyDirectory(file, destFile, params);
                    continue;
                }
                FileUtil.doCopyFile(file, destFile, params);
            }
            catch (IOException ioex) {
                if (params.continueOnError) {
                    exception = ioex;
                    continue;
                }
                throw ioex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void moveFile(String src, String dest) throws IOException {
        FileUtil.moveFile(FileUtil.file(src), FileUtil.file(dest), JoddCore.fileUtilParams);
    }

    public static void moveFile(String src, String dest, FileUtilParams params) throws IOException {
        FileUtil.moveFile(FileUtil.file(src), FileUtil.file(dest), params);
    }

    public static void moveFile(File src, File dest) throws IOException {
        FileUtil.moveFile(src, dest, JoddCore.fileUtilParams);
    }

    public static void moveFile(File src, File dest, FileUtilParams params) throws IOException {
        FileUtil.checkFileCopy(src, dest, params);
        FileUtil.doMoveFile(src, dest, params);
    }

    private static void doMoveFile(File src, File dest, FileUtilParams params) throws IOException {
        boolean rename;
        if (dest.exists()) {
            if (!dest.isFile()) {
                throw new IOException(MSG_NOT_A_FILE + dest);
            }
            if (!params.overwrite) {
                throw new IOException(MSG_ALREADY_EXISTS + dest);
            }
            dest.delete();
        }
        if (!(rename = src.renameTo(dest))) {
            FileUtil.doCopyFile(src, dest, params);
            src.delete();
        }
    }

    public static void moveFileToDir(String src, String destDir) throws IOException {
        FileUtil.moveFileToDir(FileUtil.file(src), FileUtil.file(destDir), JoddCore.fileUtilParams);
    }

    public static void moveFileToDir(String src, String destDir, FileUtilParams params) throws IOException {
        FileUtil.moveFileToDir(FileUtil.file(src), FileUtil.file(destDir), params);
    }

    public static void moveFileToDir(File src, File destDir) throws IOException {
        FileUtil.moveFileToDir(src, destDir, JoddCore.fileUtilParams);
    }

    public static void moveFileToDir(File src, File destDir, FileUtilParams params) throws IOException {
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IOException(MSG_NOT_A_DIRECTORY + destDir);
        }
        FileUtil.moveFile(src, FileUtil.file(destDir, src.getName()), params);
    }

    public static void moveDir(String srcDir, String destDir) throws IOException {
        FileUtil.moveDir(FileUtil.file(srcDir), FileUtil.file(destDir));
    }

    public static void moveDir(File srcDir, File destDir) throws IOException {
        FileUtil.checkDirCopy(srcDir, destDir);
        FileUtil.doMoveDirectory(srcDir, destDir);
    }

    private static void doMoveDirectory(File src, File dest) throws IOException {
        boolean rename;
        if (dest.exists()) {
            if (!dest.isDirectory()) {
                throw new IOException(MSG_NOT_A_DIRECTORY + dest);
            }
            dest = FileUtil.file(dest, dest.getName());
            dest.mkdir();
        }
        if (!(rename = src.renameTo(dest))) {
            FileUtil.doCopyDirectory(src, dest, FileUtil.params());
            FileUtil.deleteDir(src);
        }
    }

    public static void deleteFile(String dest) throws IOException {
        FileUtil.deleteFile(FileUtil.file(dest));
    }

    public static void deleteFile(File dest) throws IOException {
        if (!dest.exists()) {
            throw new FileNotFoundException(MSG_NOT_FOUND + dest);
        }
        if (!dest.isFile()) {
            throw new IOException(MSG_NOT_A_FILE + dest);
        }
        if (!dest.delete()) {
            throw new IOException(MSG_UNABLE_TO_DELETE + dest);
        }
    }

    public static void deleteDir(String dest) throws IOException {
        FileUtil.deleteDir(FileUtil.file(dest), JoddCore.fileUtilParams);
    }

    public static void deleteDir(String dest, FileUtilParams params) throws IOException {
        FileUtil.deleteDir(FileUtil.file(dest), params);
    }

    public static void deleteDir(File dest) throws IOException {
        FileUtil.deleteDir(dest, JoddCore.fileUtilParams);
    }

    public static void deleteDir(File dest, FileUtilParams params) throws IOException {
        FileUtil.cleanDir(dest, params);
        if (!dest.delete()) {
            throw new IOException(MSG_UNABLE_TO_DELETE + dest);
        }
    }

    public static void cleanDir(String dest) throws IOException {
        FileUtil.cleanDir(FileUtil.file(dest), JoddCore.fileUtilParams);
    }

    public static void cleanDir(String dest, FileUtilParams params) throws IOException {
        FileUtil.cleanDir(FileUtil.file(dest), params);
    }

    public static void cleanDir(File dest) throws IOException {
        FileUtil.cleanDir(dest, JoddCore.fileUtilParams);
    }

    public static void cleanDir(File dest, FileUtilParams params) throws IOException {
        if (!dest.exists()) {
            throw new FileNotFoundException(MSG_NOT_FOUND + dest);
        }
        if (!dest.isDirectory()) {
            throw new IOException(MSG_NOT_A_DIRECTORY + dest);
        }
        File[] files = dest.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of: " + dest);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                if (file.isDirectory()) {
                    if (!params.recursive) continue;
                    FileUtil.deleteDir(file, params);
                    continue;
                }
                file.delete();
            }
            catch (IOException ioex) {
                if (params.continueOnError) {
                    exception = ioex;
                    continue;
                }
                throw ioex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static char[] readUTFChars(String fileName) throws IOException {
        return FileUtil.readUTFChars(FileUtil.file(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readUTFChars(File file) throws IOException {
        char[] cArray;
        if (!file.exists()) {
            throw new FileNotFoundException(MSG_NOT_FOUND + file);
        }
        if (!file.isFile()) {
            throw new IOException(MSG_NOT_A_FILE + file);
        }
        long len = file.length();
        if (len >= Integer.MAX_VALUE) {
            len = Integer.MAX_VALUE;
        }
        UnicodeInputStream in = null;
        try {
            in = new UnicodeInputStream(new FileInputStream(file), null);
            FastCharArrayWriter fastCharArrayWriter = new FastCharArrayWriter((int)len);
            String encoding = in.getDetectedEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            StreamUtil.copy((InputStream)in, (Writer)fastCharArrayWriter, encoding);
            cArray = fastCharArrayWriter.toCharArray();
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            throw throwable;
        }
        StreamUtil.close(in);
        return cArray;
    }

    public static char[] readChars(String fileName) throws IOException {
        return FileUtil.readChars(FileUtil.file(fileName), JoddCore.fileUtilParams.encoding);
    }

    public static char[] readChars(File file) throws IOException {
        return FileUtil.readChars(file, JoddCore.fileUtilParams.encoding);
    }

    public static char[] readChars(String fileName, String encoding) throws IOException {
        return FileUtil.readChars(FileUtil.file(fileName), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readChars(File file, String encoding) throws IOException {
        char[] cArray;
        if (!file.exists()) {
            throw new FileNotFoundException(MSG_NOT_FOUND + file);
        }
        if (!file.isFile()) {
            throw new IOException(MSG_NOT_A_FILE + file);
        }
        long len = file.length();
        if (len >= Integer.MAX_VALUE) {
            len = Integer.MAX_VALUE;
        }
        InputStream in = null;
        try {
            in = new FileInputStream(file);
            if (encoding.startsWith("UTF")) {
                in = new UnicodeInputStream(in, encoding);
            }
            FastCharArrayWriter fastCharArrayWriter = new FastCharArrayWriter((int)len);
            StreamUtil.copy(in, (Writer)fastCharArrayWriter, encoding);
            cArray = fastCharArrayWriter.toCharArray();
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            throw throwable;
        }
        StreamUtil.close(in);
        return cArray;
    }

    public static void writeChars(File dest, char[] data) throws IOException {
        FileUtil.outChars(dest, data, JoddCore.encoding, false);
    }

    public static void writeChars(String dest, char[] data) throws IOException {
        FileUtil.outChars(FileUtil.file(dest), data, JoddCore.encoding, false);
    }

    public static void writeChars(File dest, char[] data, String encoding) throws IOException {
        FileUtil.outChars(dest, data, encoding, false);
    }

    public static void writeChars(String dest, char[] data, String encoding) throws IOException {
        FileUtil.outChars(FileUtil.file(dest), data, encoding, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void outChars(File dest, char[] data, String encoding, boolean append) throws IOException {
        if (dest.exists() && !dest.isFile()) {
            throw new IOException(MSG_NOT_A_FILE + dest);
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest, append), encoding));
        try {
            out.write(data);
        }
        finally {
            StreamUtil.close(out);
        }
    }

    public static String readUTFString(String fileName) throws IOException {
        return FileUtil.readUTFString(FileUtil.file(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUTFString(File file) throws IOException {
        String string;
        if (!file.exists()) {
            throw new FileNotFoundException(MSG_NOT_FOUND + file);
        }
        if (!file.isFile()) {
            throw new IOException(MSG_NOT_A_FILE + file);
        }
        long len = file.length();
        if (len >= Integer.MAX_VALUE) {
            len = Integer.MAX_VALUE;
        }
        UnicodeInputStream in = null;
        try {
            in = new UnicodeInputStream(new FileInputStream(file), null);
            FastCharArrayWriter out = new FastCharArrayWriter((int)len);
            String encoding = in.getDetectedEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            StreamUtil.copy((InputStream)in, (Writer)out, encoding);
            string = out.toString();
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            throw throwable;
        }
        StreamUtil.close(in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUTFString(InputStream inputStream) throws IOException {
        String string;
        UnicodeInputStream in = null;
        try {
            in = new UnicodeInputStream(inputStream, null);
            FastCharArrayWriter out = new FastCharArrayWriter();
            String encoding = in.getDetectedEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            StreamUtil.copy((InputStream)in, (Writer)out, encoding);
            string = out.toString();
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            throw throwable;
        }
        StreamUtil.close(in);
        return string;
    }

    public static String readString(String source) throws IOException {
        return FileUtil.readString(FileUtil.file(source), JoddCore.fileUtilParams.encoding);
    }

    public static String readString(String source, String encoding) throws IOException {
        return FileUtil.readString(FileUtil.file(source), encoding);
    }

    public static String readString(File source) throws IOException {
        return FileUtil.readString(source, JoddCore.fileUtilParams.encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(File file, String encoding) throws IOException {
        String string;
        if (!file.exists()) {
            throw new FileNotFoundException(MSG_NOT_FOUND + file);
        }
        if (!file.isFile()) {
            throw new IOException(MSG_NOT_A_FILE + file);
        }
        long len = file.length();
        if (len >= Integer.MAX_VALUE) {
            len = Integer.MAX_VALUE;
        }
        InputStream in = null;
        try {
            in = new FileInputStream(file);
            if (encoding.startsWith("UTF")) {
                in = new UnicodeInputStream(in, encoding);
            }
            FastCharArrayWriter out = new FastCharArrayWriter((int)len);
            StreamUtil.copy(in, (Writer)out, encoding);
            string = out.toString();
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            throw throwable;
        }
        StreamUtil.close(in);
        return string;
    }

    public static void writeString(String dest, String data) throws IOException {
        FileUtil.outString(FileUtil.file(dest), data, JoddCore.fileUtilParams.encoding, false);
    }

    public static void writeString(String dest, String data, String encoding) throws IOException {
        FileUtil.outString(FileUtil.file(dest), data, encoding, false);
    }

    public static void writeString(File dest, String data) throws IOException {
        FileUtil.outString(dest, data, JoddCore.fileUtilParams.encoding, false);
    }

    public static void writeString(File dest, String data, String encoding) throws IOException {
        FileUtil.outString(dest, data, encoding, false);
    }

    public static void appendString(String dest, String data) throws IOException {
        FileUtil.outString(FileUtil.file(dest), data, JoddCore.fileUtilParams.encoding, true);
    }

    public static void appendString(String dest, String data, String encoding) throws IOException {
        FileUtil.outString(FileUtil.file(dest), data, encoding, true);
    }

    public static void appendString(File dest, String data) throws IOException {
        FileUtil.outString(dest, data, JoddCore.fileUtilParams.encoding, true);
    }

    public static void appendString(File dest, String data, String encoding) throws IOException {
        FileUtil.outString(dest, data, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void outString(File dest, String data, String encoding, boolean append) throws IOException {
        if (dest.exists() && !dest.isFile()) {
            throw new IOException(MSG_NOT_A_FILE + dest);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest, append);
            out.write(data.getBytes(encoding));
        }
        catch (Throwable throwable) {
            StreamUtil.close(out);
            throw throwable;
        }
        StreamUtil.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(File dest, InputStream in) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest);
            StreamUtil.copy(in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            StreamUtil.close(out);
            throw throwable;
        }
        StreamUtil.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(String dest, InputStream in) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest);
            StreamUtil.copy(in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            StreamUtil.close(out);
            throw throwable;
        }
        StreamUtil.close(out);
    }

    public static String[] readLines(String source) throws IOException {
        return FileUtil.readLines(FileUtil.file(source), JoddCore.fileUtilParams.encoding);
    }

    public static String[] readLines(String source, String encoding) throws IOException {
        return FileUtil.readLines(FileUtil.file(source), encoding);
    }

    public static String[] readLines(File source) throws IOException {
        return FileUtil.readLines(source, JoddCore.fileUtilParams.encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readLines(File file, String encoding) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(MSG_NOT_FOUND + file);
        }
        if (!file.isFile()) {
            throw new IOException(MSG_NOT_A_FILE + file);
        }
        ArrayList<String> list = new ArrayList<String>();
        InputStream in = null;
        try {
            String strLine;
            in = new FileInputStream(file);
            if (encoding.startsWith("UTF")) {
                in = new UnicodeInputStream(in, encoding);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(in, encoding));
            while ((strLine = br.readLine()) != null) {
                list.add(strLine);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            throw throwable;
        }
        StreamUtil.close(in);
        return list.toArray(new String[list.size()]);
    }

    public static byte[] readBytes(String file) throws IOException {
        return FileUtil.readBytes(FileUtil.file(file));
    }

    public static byte[] readBytes(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(MSG_NOT_FOUND + file);
        }
        if (!file.isFile()) {
            throw new IOException(MSG_NOT_A_FILE + file);
        }
        long len = file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new IOException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        randomAccessFile.readFully(bytes);
        randomAccessFile.close();
        return bytes;
    }

    public static void writeBytes(String dest, byte[] data) throws IOException {
        FileUtil.outBytes(FileUtil.file(dest), data, 0, data.length, false);
    }

    public static void writeBytes(String dest, byte[] data, int off, int len) throws IOException {
        FileUtil.outBytes(FileUtil.file(dest), data, off, len, false);
    }

    public static void writeBytes(File dest, byte[] data) throws IOException {
        FileUtil.outBytes(dest, data, 0, data.length, false);
    }

    public static void writeBytes(File dest, byte[] data, int off, int len) throws IOException {
        FileUtil.outBytes(dest, data, off, len, false);
    }

    public static void appendBytes(String dest, byte[] data) throws IOException {
        FileUtil.outBytes(FileUtil.file(dest), data, 0, data.length, true);
    }

    public static void appendBytes(String dest, byte[] data, int off, int len) throws IOException {
        FileUtil.outBytes(FileUtil.file(dest), data, off, len, true);
    }

    public static void appendBytes(File dest, byte[] data) throws IOException {
        FileUtil.outBytes(dest, data, 0, data.length, true);
    }

    public static void appendBytes(File dest, byte[] data, int off, int len) throws IOException {
        FileUtil.outBytes(dest, data, off, len, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void outBytes(File dest, byte[] data, int off, int len, boolean append) throws IOException {
        if (dest.exists() && !dest.isFile()) {
            throw new IOException(MSG_NOT_A_FILE + dest);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest, append);
            out.write(data, off, len);
        }
        catch (Throwable throwable) {
            StreamUtil.close(out);
            throw throwable;
        }
        StreamUtil.close(out);
    }

    public static boolean compare(String file1, String file2) throws IOException {
        return FileUtil.compare(FileUtil.file(file1), FileUtil.file(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compare(File file1, File file2) throws IOException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (!file1.isFile() || !file2.isFile()) {
            throw new IOException("Only files can be compared");
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        if (FileUtil.equals(file1, file2)) {
            return true;
        }
        FileInputStream input1 = null;
        FileInputStream input2 = null;
        try {
            input1 = new FileInputStream(file1);
            input2 = new FileInputStream(file2);
            bl = StreamUtil.compare(input1, input2);
        }
        catch (Throwable throwable) {
            StreamUtil.close(input1);
            StreamUtil.close(input2);
            throw throwable;
        }
        StreamUtil.close(input1);
        StreamUtil.close(input2);
        return bl;
    }

    public static boolean isNewer(String file, String reference) {
        return FileUtil.isNewer(FileUtil.file(file), FileUtil.file(reference));
    }

    public static boolean isNewer(File file, File reference) {
        if (!reference.exists()) {
            throw new IllegalArgumentException("Reference file not found: " + reference);
        }
        return FileUtil.isNewer(file, reference.lastModified());
    }

    public static boolean isOlder(String file, String reference) {
        return FileUtil.isOlder(FileUtil.file(file), FileUtil.file(reference));
    }

    public static boolean isOlder(File file, File reference) {
        if (!reference.exists()) {
            throw new IllegalArgumentException("Reference file not found: " + reference);
        }
        return FileUtil.isOlder(file, reference.lastModified());
    }

    public static boolean isNewer(File file, long timeMillis) {
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() > timeMillis;
    }

    public static boolean isNewer(String file, long timeMillis) {
        return FileUtil.isNewer(FileUtil.file(file), timeMillis);
    }

    public static boolean isOlder(File file, long timeMillis) {
        if (!file.exists()) {
            return false;
        }
        return file.lastModified() < timeMillis;
    }

    public static boolean isOlder(String file, long timeMillis) {
        return FileUtil.isOlder(FileUtil.file(file), timeMillis);
    }

    public static void copy(String src, String dest) throws IOException {
        FileUtil.copy(FileUtil.file(src), FileUtil.file(dest), JoddCore.fileUtilParams);
    }

    public static void copy(String src, String dest, FileUtilParams params) throws IOException {
        FileUtil.copy(FileUtil.file(src), FileUtil.file(dest), params);
    }

    public static void copy(File src, File dest) throws IOException {
        FileUtil.copy(src, dest, JoddCore.fileUtilParams);
    }

    public static void copy(File src, File dest, FileUtilParams params) throws IOException {
        if (src.isDirectory()) {
            FileUtil.copyDir(src, dest, params);
            return;
        }
        if (dest.isDirectory()) {
            FileUtil.copyFileToDir(src, dest, params);
            return;
        }
        FileUtil.copyFile(src, dest, params);
    }

    public static void move(String src, String dest) throws IOException {
        FileUtil.move(FileUtil.file(src), FileUtil.file(dest), JoddCore.fileUtilParams);
    }

    public static void move(String src, String dest, FileUtilParams params) throws IOException {
        FileUtil.move(FileUtil.file(src), FileUtil.file(dest), params);
    }

    public static void move(File src, File dest) throws IOException {
        FileUtil.move(src, dest, JoddCore.fileUtilParams);
    }

    public static void move(File src, File dest, FileUtilParams params) throws IOException {
        if (src.isDirectory()) {
            FileUtil.moveDir(src, dest);
            return;
        }
        if (dest.isDirectory()) {
            FileUtil.moveFileToDir(src, dest, params);
            return;
        }
        FileUtil.moveFile(src, dest, params);
    }

    public static void delete(String dest) throws IOException {
        FileUtil.delete(FileUtil.file(dest), JoddCore.fileUtilParams);
    }

    public static void delete(String dest, FileUtilParams params) throws IOException {
        FileUtil.delete(FileUtil.file(dest), params);
    }

    public static void delete(File dest) throws IOException {
        FileUtil.delete(dest, JoddCore.fileUtilParams);
    }

    public static void delete(File dest, FileUtilParams params) throws IOException {
        if (dest.isDirectory()) {
            FileUtil.deleteDir(dest, params);
            return;
        }
        FileUtil.deleteFile(dest);
    }

    public static boolean isAncestor(File ancestor, File file, boolean strict) {
        File parent;
        File file2 = parent = strict ? FileUtil.getParentFile(file) : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = FileUtil.getParentFile(parent);
        }
        return false;
    }

    public static File getParentFile(File file) {
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static boolean isFilePathAcceptable(File file, FileFilter fileFilter) {
        do {
            if (fileFilter == null || fileFilter.accept(file)) continue;
            return false;
        } while ((file = file.getParentFile()) != null);
        return true;
    }

    public static File createTempDirectory() throws IOException {
        return FileUtil.createTempDirectory(JoddCore.tempFilePrefix, null, null);
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return FileUtil.createTempDirectory(prefix, suffix, null);
    }

    public static File createTempDirectory(String prefix, String suffix, File tempDir) throws IOException {
        File file = FileUtil.createTempFile(prefix, suffix, tempDir);
        file.delete();
        file.mkdir();
        return file;
    }

    public static File createTempFile() throws IOException {
        return FileUtil.createTempFile(JoddCore.tempFilePrefix, null, null, true);
    }

    public static File createTempFile(String prefix, String suffix, File tempDir, boolean create) throws IOException {
        File file = FileUtil.createTempFile(prefix, suffix, tempDir);
        file.delete();
        if (create) {
            file.createNewFile();
        }
        return file;
    }

    public static File createTempFile(String prefix, String suffix, File dir) throws IOException {
        int exceptionsCount = 0;
        while (true) {
            try {
                return File.createTempFile(prefix, suffix, dir).getCanonicalFile();
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw ioex;
            }
            break;
        }
    }

    public static boolean isSymlink(File file) throws IOException {
        File fileInCanonicalDir;
        if (SystemUtil.isHostWindows()) {
            return false;
        }
        if (file.getParent() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return !fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }
}

