/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import jodd.typeconverter.ConvertBean;
import jodd.typeconverter.TypeConverter;
import jodd.util.CsvUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatArrayConverter
implements TypeConverter<float[]> {
    protected final ConvertBean convertBean;

    public FloatArrayConverter(ConvertBean convertBean) {
        this.convertBean = convertBean;
    }

    @Override
    public float[] convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!type.isArray()) {
            if (type == String.class) {
                Object[] values = CsvUtil.toStringArray(value.toString());
                return this.convertArray(values);
            }
            return new float[]{this.convertBean.toFloatValue(value)};
        }
        if (type.getComponentType().isPrimitive()) {
            if (type == float[].class) {
                return (float[])value;
            }
            if (type == double[].class) {
                double[] values = (double[])value;
                float[] results = new float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = (float)values[i];
                }
                return results;
            }
            if (type == int[].class) {
                int[] values = (int[])value;
                float[] results = new float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == long[].class) {
                long[] values = (long[])value;
                float[] results = new float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == byte[].class) {
                byte[] values = (byte[])value;
                float[] results = new float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
            if (type == boolean[].class) {
                boolean[] values = (boolean[])value;
                float[] results = new float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i] ? 1 : 0;
                }
                return results;
            }
            if (type == short[].class) {
                short[] values = (short[])value;
                float[] results = new float[values.length];
                for (int i = 0; i < values.length; ++i) {
                    results[i] = values[i];
                }
                return results;
            }
        }
        return this.convertArray((Object[])value);
    }

    protected float[] convertArray(Object[] values) {
        float[] results = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            results[i] = this.convertBean.toFloatValue(values[i]);
        }
        return results;
    }
}

