/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.StringUtil;
import jodd.util.TimeUtil;

public class LocalDateTimeConverter
implements TypeConverter<LocalDateTime> {
    @Override
    public LocalDateTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return TimeUtil.fromCalendar((Calendar)((Calendar)value));
        }
        if (value instanceof Timestamp) {
            return TimeUtil.fromMilliseconds((long)((Timestamp)value).getTime());
        }
        if (value instanceof Date) {
            return TimeUtil.fromDate((Date)((Date)value));
        }
        if (value instanceof Number) {
            return TimeUtil.fromMilliseconds((long)((Number)value).longValue());
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits((CharSequence)stringValue)) {
            return LocalDateTime.parse(stringValue);
        }
        try {
            return TimeUtil.fromMilliseconds((long)Long.parseLong(stringValue));
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

