/*
 * Decompiled with CFR 0.152.
 */
package jodd.typeconverter.impl;

import java.util.Calendar;
import java.util.Date;
import jodd.datetime.JDateTime;
import jodd.typeconverter.TypeConversionException;
import jodd.typeconverter.TypeConverter;
import jodd.util.StringUtil;

public class DateConverter
implements TypeConverter<Date> {
    @Override
    public Date convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Calendar) {
            return new Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof JDateTime) {
            return ((JDateTime)value).convertToDate();
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits((CharSequence)stringValue)) {
            JDateTime jdt = new JDateTime(stringValue, "YYYY-MM-DD hh:mm:ss.mss");
            return jdt.convertToDate();
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new Date(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

