/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties {
    protected final ClassDescriptor classDescriptor;
    protected final HashMap<String, PropertyDescriptor> propertyDescriptors;
    private PropertyDescriptor[] allProperties;

    public Properties(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.propertyDescriptors = this.inspectProperties();
    }

    protected HashMap<String, PropertyDescriptor> inspectProperties() {
        boolean scanAccessible = this.classDescriptor.isScanAccessible();
        Class type = this.classDescriptor.getType();
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        Method[] methods = scanAccessible ? ReflectUtil.getAccessibleMethods((Class)type) : ReflectUtil.getSupportedMethods((Class)type);
        for (int iteration = 0; iteration < 2; ++iteration) {
            for (Method method : methods) {
                String propertyName;
                if (Modifier.isStatic(method.getModifiers())) continue;
                boolean add = false;
                boolean issetter = false;
                if (iteration == 0) {
                    propertyName = ReflectUtil.getBeanPropertyGetterName((Method)method);
                    if (propertyName != null) {
                        add = true;
                        issetter = false;
                    }
                } else {
                    propertyName = ReflectUtil.getBeanPropertySetterName((Method)method);
                    if (propertyName != null) {
                        add = true;
                        issetter = true;
                    }
                }
                if (!add) continue;
                MethodDescriptor methodDescriptor = this.classDescriptor.getMethodDescriptor(method.getName(), method.getParameterTypes(), true);
                this.addProperty(map, propertyName, methodDescriptor, issetter);
            }
        }
        if (this.classDescriptor.isIncludeFieldsAsProperties()) {
            FieldDescriptor[] fieldDescriptors = this.classDescriptor.getAllFieldDescriptors();
            String[] prefix = this.classDescriptor.getPropertyFieldPrefix();
            for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
                Field field = fieldDescriptor.getField();
                if (Modifier.isStatic(field.getModifiers())) continue;
                String name = field.getName();
                if (prefix != null) {
                    for (String p : prefix) {
                        if (!name.startsWith(p)) continue;
                        name = name.substring(p.length());
                        break;
                    }
                }
                if (map.containsKey(name)) continue;
                map.put(name, this.createPropertyDescriptor(name, fieldDescriptor));
            }
        }
        return map;
    }

    protected void addProperty(HashMap<String, PropertyDescriptor> map, String name, MethodDescriptor methodDescriptor, boolean isSetter) {
        MethodDescriptor setterMethod = isSetter ? methodDescriptor : null;
        MethodDescriptor getterMethod = isSetter ? null : methodDescriptor;
        PropertyDescriptor existing = map.get(name);
        if (existing == null) {
            PropertyDescriptor propertyDescriptor = this.createPropertyDescriptor(name, getterMethod, setterMethod);
            map.put(name, propertyDescriptor);
            return;
        }
        if (!isSetter) {
            setterMethod = existing.getWriteMethodDescriptor();
            MethodDescriptor existingMethodDescriptor = existing.getReadMethodDescriptor();
            if (existingMethodDescriptor != null) {
                String methodName = methodDescriptor.getMethod().getName();
                String existingMethodName = existingMethodDescriptor.getMethod().getName();
                if (existingMethodName.startsWith("is") && methodName.startsWith("get")) {
                    return;
                }
            }
        } else {
            getterMethod = existing.getReadMethodDescriptor();
            if (getterMethod != null) {
                Class<?> parameterType;
                Class<?> returnType = getterMethod.getMethod().getReturnType();
                if (setterMethod != null && returnType != (parameterType = setterMethod.getMethod().getParameterTypes()[0])) {
                    return;
                }
            }
        }
        PropertyDescriptor propertyDescriptor = this.createPropertyDescriptor(name, getterMethod, setterMethod);
        map.put(name, propertyDescriptor);
    }

    protected PropertyDescriptor createPropertyDescriptor(String name, MethodDescriptor getterMethod, MethodDescriptor setterMethod) {
        return new PropertyDescriptor(this.classDescriptor, name, getterMethod, setterMethod);
    }

    protected PropertyDescriptor createPropertyDescriptor(String name, FieldDescriptor fieldDescriptor) {
        return new PropertyDescriptor(this.classDescriptor, name, fieldDescriptor);
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.propertyDescriptors.get(name);
    }

    public PropertyDescriptor[] getAllPropertyDescriptors() {
        if (this.allProperties == null) {
            PropertyDescriptor[] allProperties = new PropertyDescriptor[this.propertyDescriptors.size()];
            int index = 0;
            Iterator<PropertyDescriptor> i$ = this.propertyDescriptors.values().iterator();
            while (i$.hasNext()) {
                PropertyDescriptor propertyDescriptor;
                allProperties[index] = propertyDescriptor = i$.next();
                ++index;
            }
            Arrays.sort(allProperties, new Comparator<PropertyDescriptor>(){

                @Override
                public int compare(PropertyDescriptor pd1, PropertyDescriptor pd2) {
                    return pd1.getName().compareTo(pd2.getName());
                }
            });
            this.allProperties = allProperties;
        }
        return this.allProperties;
    }
}

