/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import jodd.bean.BeanUtil;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.util.InExRuleMatcher;
import jodd.util.InExRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanVisitor
implements InExRuleMatcher<String, String> {
    protected Object source;
    protected InExRules<String, String> rules = new InExRules((InExRuleMatcher)this);
    protected boolean declared;
    protected boolean ignoreNullValues;
    protected boolean includeFields;
    protected boolean blacklist = true;

    protected String[] getAllBeanPropertyNames(Class type, boolean declared) {
        ClassDescriptor classDescriptor = ClassIntrospector.lookup(type);
        PropertyDescriptor[] propertyDescriptors = classDescriptor.getAllPropertyDescriptors();
        ArrayList<String> names = new ArrayList<String>(propertyDescriptors.length);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            FieldDescriptor field;
            MethodDescriptor getter = propertyDescriptor.getReadMethodDescriptor();
            if (getter != null) {
                if (!getter.matchDeclared(declared)) continue;
                names.add(propertyDescriptor.getName());
                continue;
            }
            if (!this.includeFields || (field = propertyDescriptor.getFieldDescriptor()) == null || !field.matchDeclared(declared)) continue;
            names.add(field.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    protected String[] resolveProperties(Object bean, boolean declared) {
        String[] properties;
        if (bean instanceof Map) {
            Set keys = ((Map)bean).keySet();
            properties = new String[keys.size()];
            int ndx = 0;
            for (Object key : keys) {
                properties[ndx] = key.toString();
                ++ndx;
            }
        } else {
            properties = this.getAllBeanPropertyNames(bean.getClass(), declared);
        }
        return properties;
    }

    public void visit() {
        String[] properties;
        for (String name : properties = this.resolveProperties(this.source, this.declared)) {
            Object value;
            if (name == null || !this.rules.match((Object)name, this.blacklist) || (value = this.declared ? BeanUtil.getDeclaredProperty(this.source, name) : BeanUtil.getProperty(this.source, name)) == null && this.ignoreNullValues) continue;
            this.visitProperty(name, value);
        }
    }

    protected abstract boolean visitProperty(String var1, Object var2);

    public boolean accept(String propertyName, String rule, boolean include) {
        return propertyName.equals(rule);
    }
}

