/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.util.ArraysUtil;
import jodd.util.ReflectUtil;

class Methods {
    private final ClassDescriptor classDescriptor;
    private final HashMap<String, MethodDescriptor[]> methodsMap;
    private int count;
    private Method[] allMethods;

    Methods(ClassDescriptor classDescriptor, int maxMethods) {
        this.classDescriptor = classDescriptor;
        if (maxMethods == 0) {
            maxMethods = 16;
        }
        this.methodsMap = new HashMap(maxMethods);
        this.count = 0;
    }

    void addMethod(String name, Method method) {
        Object[] mds = this.methodsMap.get(name);
        mds = mds == null ? new MethodDescriptor[1] : (MethodDescriptor[])ArraysUtil.resize((Object[])mds, (int)(mds.length + 1));
        this.methodsMap.put(name, (MethodDescriptor[])mds);
        mds[mds.length - 1] = new MethodDescriptor(this.classDescriptor, method);
        ++this.count;
        this.allMethods = null;
    }

    Method getMethod(String name, Class[] paramTypes) {
        MethodDescriptor methodDescriptor = this.getMethodDescriptor(name, paramTypes);
        if (methodDescriptor == null) {
            return null;
        }
        return methodDescriptor.getMethod();
    }

    MethodDescriptor getMethodDescriptor(String name, Class[] paramTypes) {
        MethodDescriptor[] methodDescriptors = this.methodsMap.get(name);
        if (methodDescriptors == null) {
            return null;
        }
        for (int i = 0; i < methodDescriptors.length; ++i) {
            Method m = methodDescriptors[i].getMethod();
            if (!ReflectUtil.compareParameters((Class[])m.getParameterTypes(), (Class[])paramTypes)) continue;
            return methodDescriptors[i];
        }
        return null;
    }

    Method getMethod(String name) {
        MethodDescriptor methodDescriptor = this.getMethodDescriptor(name);
        if (methodDescriptor == null) {
            return null;
        }
        return methodDescriptor.getMethod();
    }

    MethodDescriptor getMethodDescriptor(String name) {
        MethodDescriptor[] methodDescriptors = this.methodsMap.get(name);
        if (methodDescriptors == null) {
            return null;
        }
        if (methodDescriptors.length != 1) {
            throw new IllegalArgumentException("Method name not unique: " + name);
        }
        return methodDescriptors[0];
    }

    Method[] getAllMethods(String name) {
        MethodDescriptor[] methodDescriptors = this.methodsMap.get(name);
        if (methodDescriptors == null) {
            return new Method[0];
        }
        ArrayList<Method> allMethodsList = new ArrayList<Method>();
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            allMethodsList.add(methodDescriptor.getMethod());
        }
        return allMethodsList.toArray(new Method[allMethodsList.size()]);
    }

    Method[] getAllMethods() {
        if (this.allMethods == null) {
            ArrayList<Method> allMethodsList = new ArrayList<Method>();
            for (MethodDescriptor[] methodDescriptors : this.methodsMap.values()) {
                for (MethodDescriptor methodDescriptor : methodDescriptors) {
                    allMethodsList.add(methodDescriptor.getMethod());
                }
            }
            this.allMethods = allMethodsList.toArray(new Method[allMethodsList.size()]);
        }
        return this.allMethods;
    }

    int getCount() {
        return this.count;
    }

    void removeMethods(String name) {
        MethodDescriptor[] removed = this.methodsMap.remove(name);
        if (removed != null) {
            this.allMethods = null;
            this.count -= removed.length;
        }
    }
}

