/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.introspector.Ctors;
import jodd.introspector.Fields;
import jodd.introspector.Methods;
import jodd.introspector.Properties;
import jodd.util.ReflectUtil;

public class ClassDescriptor {
    protected final Class type;
    protected final boolean accessibleOnly;
    protected int usageCount;
    private boolean isArray;
    private boolean isMap;
    private boolean isList;
    private boolean isSet;
    private boolean isCollection;
    protected Fields publicFields;
    protected Fields allFields;
    protected Methods publicMethods;
    protected Methods allMethods;
    protected Properties publicProperties;
    protected Properties allProperties;
    protected Ctors publicCtors;
    protected Ctors allCtors;

    public ClassDescriptor(Class type, boolean accessibleOnly) {
        this.type = type;
        this.isArray = type.isArray();
        this.isMap = ReflectUtil.isSubclass((Class)type, Map.class);
        this.isList = ReflectUtil.isSubclass((Class)type, List.class);
        this.isSet = ReflectUtil.isSubclass((Class)type, Set.class);
        this.isCollection = ReflectUtil.isSubclass((Class)type, Collection.class);
        this.accessibleOnly = accessibleOnly;
    }

    public Class getType() {
        return this.type;
    }

    protected void increaseUsageCount() {
        ++this.usageCount;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    protected void inspectFields() {
        if (this.allFields != null) {
            return;
        }
        Field[] fields = this.accessibleOnly ? ReflectUtil.getAccessibleFields((Class)this.type) : ReflectUtil.getSupportedFields((Class)this.type);
        Fields publicFields = new Fields(fields.length);
        Fields allFields = new Fields(fields.length);
        for (Field field : fields) {
            String fName = field.getName();
            if (ReflectUtil.isPublic((Member)field)) {
                publicFields.addField(fName, field);
            }
            ReflectUtil.forceAccess((AccessibleObject)field);
            allFields.addField(fName, field);
        }
        publicFields.lock();
        allFields.lock();
        this.publicFields = publicFields;
        this.allFields = allFields;
    }

    public Field getField(String name, boolean declared) {
        this.inspectFields();
        if (declared) {
            return this.allFields.getField(name);
        }
        return this.publicFields.getField(name);
    }

    public int getFieldCount(boolean declared) {
        this.inspectFields();
        if (declared) {
            return this.allFields.getCount();
        }
        return this.publicFields.getCount();
    }

    public Field[] getAllFields(boolean declared) {
        this.inspectFields();
        if (declared) {
            return this.allFields.getAllFields();
        }
        return this.publicFields.getAllFields();
    }

    protected void inspectMethods() {
        Method[] methods;
        if (this.allMethods != null) {
            return;
        }
        Methods publicMethods = new Methods();
        Methods allMethods = new Methods();
        for (Method method : methods = this.accessibleOnly ? ReflectUtil.getAccessibleMethods((Class)this.type) : ReflectUtil.getSupportedMethods((Class)this.type)) {
            String methodName = method.getName();
            if (ReflectUtil.isPublic((Member)method)) {
                publicMethods.addMethod(methodName, method);
            }
            ReflectUtil.forceAccess((AccessibleObject)method);
            allMethods.addMethod(methodName, method);
        }
        allMethods.lock();
        publicMethods.lock();
        this.allMethods = allMethods;
        this.publicMethods = publicMethods;
    }

    public Method getMethod(String name, boolean declared) {
        this.inspectMethods();
        if (declared) {
            return this.allMethods.getMethod(name);
        }
        return this.publicMethods.getMethod(name);
    }

    public Method getMethod(String name, Class[] params, boolean declared) {
        this.inspectMethods();
        if (declared) {
            return this.allMethods.getMethod(name, params);
        }
        return this.publicMethods.getMethod(name, params);
    }

    public Method[] getAllMethods(String name, boolean declared) {
        this.inspectMethods();
        if (declared) {
            return this.allMethods.getAllMethods(name);
        }
        return this.publicMethods.getAllMethods(name);
    }

    public Method[] getAllMethods(boolean declared) {
        this.inspectMethods();
        if (declared) {
            return this.allMethods.getAllMethods();
        }
        return this.publicMethods.getAllMethods();
    }

    protected void inspectProperties() {
        Method[] methods;
        if (this.publicProperties != null) {
            return;
        }
        Properties publicProperties = new Properties();
        Properties allProperties = new Properties();
        for (Method method : methods = this.accessibleOnly ? ReflectUtil.getAccessibleMethods((Class)this.type) : ReflectUtil.getSupportedMethods((Class)this.type)) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            boolean add = false;
            String methodName = ReflectUtil.getBeanPropertyGetterName((Method)method);
            if (methodName != null) {
                methodName = '-' + methodName;
                add = true;
            } else {
                methodName = ReflectUtil.getBeanPropertySetterName((Method)method);
                if (methodName != null) {
                    methodName = '+' + methodName;
                    add = true;
                }
            }
            if (!add) continue;
            if (ReflectUtil.isPublic((Member)method)) {
                publicProperties.addMethod(methodName, method);
            }
            ReflectUtil.forceAccess((AccessibleObject)method);
            allProperties.addMethod(methodName, method);
        }
        allProperties.lock();
        publicProperties.lock();
        this.allProperties = allProperties;
        this.publicProperties = publicProperties;
    }

    public Method getBeanSetter(String name, boolean declared) {
        this.inspectProperties();
        if (declared) {
            return this.allProperties.setters.getMethod(name);
        }
        return this.publicProperties.setters.getMethod(name);
    }

    public Method[] getAllBeanSetters(boolean declared) {
        this.inspectProperties();
        if (declared) {
            return this.allProperties.setters.getAllMethods();
        }
        return this.publicProperties.setters.getAllMethods();
    }

    public String[] getAllBeanSetterNames(boolean declared) {
        this.inspectProperties();
        if (declared) {
            return this.allProperties.setterNames;
        }
        return this.publicProperties.setterNames;
    }

    public Method getBeanGetter(String name, boolean declared) {
        this.inspectProperties();
        if (declared) {
            return this.allProperties.getters.getMethod(name);
        }
        return this.publicProperties.getters.getMethod(name);
    }

    public Method[] getAllBeanGetters(boolean declared) {
        this.inspectProperties();
        if (declared) {
            return this.allProperties.getters.getAllMethods();
        }
        return this.publicProperties.getters.getAllMethods();
    }

    public String[] getAllBeanGetterNames(boolean declared) {
        this.inspectProperties();
        if (declared) {
            return this.allProperties.getterNames;
        }
        return this.publicProperties.getterNames;
    }

    protected void inspectCtors() {
        Constructor[] ctors;
        if (this.allCtors != null) {
            return;
        }
        Ctors publicCtors = new Ctors();
        Ctors allCtors = new Ctors();
        publicCtors.addCtors(this.type.getConstructors());
        allCtors.addCtors(this.type.getDeclaredConstructors());
        for (Constructor ctor : ctors = allCtors.getAllCtors()) {
            if (ReflectUtil.isPublic((Member)ctor)) continue;
            ReflectUtil.forceAccess((AccessibleObject)ctor);
        }
        publicCtors.lock();
        allCtors.lock();
        this.publicCtors = publicCtors;
        this.allCtors = allCtors;
    }

    public Constructor getDefaultCtor(boolean declared) {
        this.inspectCtors();
        if (declared) {
            return this.allCtors.getDefaultCtor();
        }
        return this.publicCtors.getDefaultCtor();
    }

    public Constructor getCtor(Class[] args, boolean declared) {
        this.inspectCtors();
        if (declared) {
            return this.allCtors.getCtor(args);
        }
        return this.publicCtors.getCtor(args);
    }

    public Constructor getDefaultCtor() {
        this.inspectCtors();
        return this.publicCtors.getDefaultCtor();
    }

    public int getCtorCount(boolean declared) {
        this.inspectCtors();
        if (declared) {
            return this.allCtors.getCount();
        }
        return this.publicCtors.getCount();
    }

    public Constructor[] getAllCtors(boolean declared) {
        this.inspectCtors();
        if (declared) {
            return this.allCtors.getAllCtors();
        }
        return this.publicCtors.getAllCtors();
    }
}

