/*
 * Decompiled with CFR 0.152.
 */
package jodd.vtor.constraint;

import java.time.LocalDateTime;
import jodd.typeconverter.TypeConverterManager;
import jodd.typeconverter.impl.LocalDateTimeConverter;
import jodd.vtor.ValidationConstraint;
import jodd.vtor.ValidationConstraintContext;
import jodd.vtor.constraint.TimeAfter;

public class TimeAfterConstraint
implements ValidationConstraint<TimeAfter> {
    protected LocalDateTime time;

    public TimeAfterConstraint() {
    }

    public TimeAfterConstraint(LocalDateTime time) {
        this.time = time;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public void setTime(LocalDateTime time) {
        this.time = time;
    }

    @Override
    public void configure(TimeAfter annotation) {
        this.time = LocalDateTime.parse(annotation.value());
    }

    @Override
    public boolean isValid(ValidationConstraintContext vcc, Object value) {
        return TimeAfterConstraint.validate(value, this.time);
    }

    public static boolean validate(Object value, LocalDateTime then) {
        if (value == null) {
            return true;
        }
        LocalDateTimeConverter ldtc = (LocalDateTimeConverter)TypeConverterManager.get().lookup(LocalDateTime.class);
        LocalDateTime now = ldtc.convert(value);
        return now.isAfter(then);
    }
}

