/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.advice;

import java.lang.reflect.Field;
import jodd.cache.TypeCache;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.Proxetta;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.advice.DelegateAdvice;
import jodd.proxetta.impl.ProxyProxetta;
import jodd.util.ClassUtil;

public class DelegateAdviceUtil {
    public static TypeCache<Class> cache = TypeCache.create().threadsafe(true).get();
    private static final ProxyProxetta PROXY_PROXETTA = (ProxyProxetta)Proxetta.proxyProxetta().withAspect(ProxyAspect.of(DelegateAdvice.class, MethodInfo::isPublicMethod));

    public static <T> T applyAdvice(Class<T> targetClass) {
        Class adviceClass = cache.get(targetClass, t -> PROXY_PROXETTA.proxy().setTarget((Class)t).define());
        try {
            Object advice = ClassUtil.newInstance(adviceClass);
            Field field = adviceClass.getField("$___target$0");
            field.set(advice, targetClass);
            return advice;
        }
        catch (Exception ex) {
            throw new ProxettaException(ex);
        }
    }

    public static void injectTargetIntoProxy(Object proxy, Object target) {
        Class<?> proxyClass = proxy.getClass();
        try {
            Field field = proxyClass.getField("$___target$0");
            field.set(proxy, target);
        }
        catch (Exception ex) {
            throw new ProxettaException(ex);
        }
    }
}

