/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta;

import java.lang.reflect.Field;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.ProxettaNames;

public class ProxettaUtil {
    public static Class resolveTargetClass(Class proxy) {
        String name = proxy.getName();
        if (name.endsWith(ProxettaNames.proxyClassNameSuffix)) {
            return proxy.getSuperclass();
        }
        if (name.endsWith(ProxettaNames.wrapperClassNameSuffix)) {
            return ProxettaUtil.getTargetWrapperType(proxy);
        }
        return proxy;
    }

    public static void injectTargetIntoWrapper(Object target, Object wrapper, String targetFieldName) {
        try {
            Field field = wrapper.getClass().getField(targetFieldName);
            field.setAccessible(true);
            field.set(wrapper, target);
        }
        catch (Exception ex) {
            throw new ProxettaException(ex);
        }
    }

    public static void injectTargetIntoWrapper(Object target, Object wrapper) {
        ProxettaUtil.injectTargetIntoWrapper(target, wrapper, ProxettaNames.wrapperTargetFieldName);
    }

    public static Class getTargetWrapperType(Class wrapperClass) {
        try {
            Field field = wrapperClass.getDeclaredField(ProxettaNames.wrapperTargetFieldName);
            return field.getType();
        }
        catch (NoSuchFieldException nsfex) {
            throw new ProxettaException(nsfex);
        }
    }
}

