/*
 * Decompiled with CFR 0.152.
 */
package jodd.pathref;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import jodd.cache.TypeCache;
import jodd.pathref.PathrefContinue;
import jodd.pathref.PathrefException;
import jodd.pathref.PathrefProxetta;
import jodd.proxetta.ProxettaUtil;
import jodd.util.ClassUtil;
import jodd.util.StringUtil;

public class Pathref<C> {
    public static final int ALL = -1;
    public static TypeCache<Class> cache = TypeCache.create().threadsafe(true).get();
    private static final PathrefProxetta proxetta = new PathrefProxetta();
    private final C instance;
    protected String path;

    public Pathref(Class<C> target) {
        C proxy = this.createProxyObject(target);
        this.instance = proxy;
        Pathref.injectPathRef(this, this.instance);
        this.path = "";
    }

    Pathref(Class<C> target, Pathref root) {
        C proxy = this.createProxyObject(target);
        this.instance = proxy;
        Pathref.injectPathRef(root, this.instance);
        this.path = null;
    }

    protected C createProxyObject(Class<C> target) {
        Object proxy;
        target = ProxettaUtil.resolveTargetClass(target);
        Class proxyClass = cache.get(target, proxetta::defineProxy);
        try {
            proxy = ClassUtil.newInstance(proxyClass);
        }
        catch (Exception ex) {
            throw new PathrefException(ex);
        }
        return (C)proxy;
    }

    protected void append(String methodName) {
        if (this.path.length() != 0) {
            this.path = this.path + ".";
        }
        if (methodName.startsWith("[")) {
            this.path = StringUtil.substring(this.path, 0, -1);
        }
        this.path = this.path + methodName;
    }

    public static <T> Pathref<T> of(Class<T> target) {
        return new Pathref<T>(target);
    }

    C get() {
        this.path = "";
        return this.instance;
    }

    public String path(Consumer<C> consumer) {
        this.path = "";
        consumer.accept(this.instance);
        return this.path;
    }

    protected static void injectPathRef(Pathref pathref, Object target) {
        try {
            Field f = target.getClass().getDeclaredField("$__pathref$0");
            f.setAccessible(true);
            f.set(target, new PathrefContinue(pathref));
        }
        catch (Exception ex) {
            throw new PathrefException("Pathref field not found", ex);
        }
    }
}

