/*
 * Decompiled with CFR 0.152.
 */
package jodd.methref;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import jodd.cache.TypeCache;
import jodd.methref.MethrefException;
import jodd.methref.MethrefProxetta;
import jodd.proxetta.ProxettaUtil;
import jodd.util.ClassUtil;

public class Methref<C> {
    public static TypeCache<Class> cache = TypeCache.create().threadsafe(true).get();
    private static final MethrefProxetta proxetta = new MethrefProxetta();
    private final C instance;

    public Methref(Class<C> target) {
        Object proxy;
        target = ProxettaUtil.resolveTargetClass(target);
        Class proxyClass = cache.get(target, proxetta::defineProxy);
        try {
            proxy = ClassUtil.newInstance(proxyClass);
        }
        catch (Exception ex) {
            throw new MethrefException(ex);
        }
        this.instance = proxy;
    }

    public static <T> Methref<T> of(Class<T> target) {
        return new Methref<T>(target);
    }

    public String name(Consumer<C> consumer) {
        consumer.accept(this.instance);
        return this.ref();
    }

    private String ref() {
        if (this.instance == null) {
            return null;
        }
        try {
            Field f = this.instance.getClass().getDeclaredField("$__methodName$0");
            f.setAccessible(true);
            Object name = f.get(this.instance);
            if (name == null) {
                throw new MethrefException("Target method not collected");
            }
            return name.toString();
        }
        catch (Exception ex) {
            if (ex instanceof MethrefException) {
                throw (MethrefException)ex;
            }
            throw new MethrefException("Methref field not found", ex);
        }
    }
}

