/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.scope;

import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.config.InjectionPoint;
import jodd.madvoc.config.Targets;
import jodd.madvoc.scope.MadvocScope;
import jodd.servlet.ServletUtil;
import jodd.util.StringUtil;

public class CookieScope
implements MadvocScope {
    @Override
    public void inject(ActionRequest actionRequest, Targets targets) {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        targets.forEachTargetAndIn(this, (target, in) -> {
            Cookie[] value = null;
            if (in.type() == Cookie.class) {
                String cookieName = StringUtil.uncapitalize(in.name());
                value = ServletUtil.getCookie(servletRequest, cookieName);
            } else if (in.type().isArray() && in.type().getComponentType().equals(Cookie.class)) {
                value = StringUtil.isEmpty(in.name()) ? servletRequest.getCookies() : ServletUtil.getAllCookies(servletRequest, in.name());
            }
            if (value != null) {
                target.writeValue((InjectionPoint)in, (Object)value, true);
            }
        });
    }

    @Override
    public void inject(ServletContext servletContext, Targets targets) {
    }

    @Override
    public void inject(Targets targets) {
    }

    @Override
    public void outject(ActionRequest actionRequest, Targets targets) {
        HttpServletResponse servletResponse = actionRequest.getHttpServletResponse();
        targets.forEachTargetAndOut(this, (target, out) -> {
            Cookie cookie = (Cookie)target.readValue((InjectionPoint)out);
            if (cookie != null) {
                servletResponse.addCookie(cookie);
            }
        });
    }
}

