/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.exception.ExceptionUtil;
import jodd.madvoc.ActionWrapper;
import jodd.madvoc.component.MadvocController;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.config.Targets;
import jodd.servlet.ServletUtil;

public class ActionRequest {
    protected final MadvocController madvocController;
    protected final ActionRuntime actionRuntime;
    protected final String actionPath;
    protected final String[] actionPathChunks;
    protected HttpServletRequest servletRequest;
    protected HttpServletResponse servletResponse;
    protected final Targets targets;
    protected final ActionWrapper[] executionArray;
    protected int executionIndex;
    protected Object action;
    protected Object actionResult;
    protected String nextActionPath;
    private String requestBody;

    public HttpServletRequest getHttpServletRequest() {
        return this.servletRequest;
    }

    public void bind(HttpServletRequest request) {
        this.servletRequest = request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.servletResponse;
    }

    public void bind(HttpServletResponse response) {
        this.servletResponse = response;
    }

    public ActionRuntime getActionRuntime() {
        return this.actionRuntime;
    }

    public Object getAction() {
        return this.action;
    }

    public String getActionPath() {
        return this.actionPath;
    }

    public String getNextActionPath() {
        return this.nextActionPath;
    }

    public void setNextActionPath(String nextActionPath) {
        this.nextActionPath = nextActionPath;
    }

    public Targets getTargets() {
        return this.targets;
    }

    public Object getActionResult() {
        return this.actionResult;
    }

    public void bindActionResult(Object actionResult) {
        this.actionResult = actionResult;
    }

    public String[] getActionPathChunks() {
        return this.actionPathChunks;
    }

    public ActionRequest(MadvocController madvocController, String actionPath, String[] actionPathChunks, ActionRuntime actionRuntime, Object action, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.madvocController = madvocController;
        this.actionPath = actionPath;
        this.actionPathChunks = actionPathChunks;
        this.actionRuntime = actionRuntime;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.action = action;
        this.targets = new Targets(this);
        this.executionIndex = 0;
        this.executionArray = this.createExecutionArray();
    }

    protected ActionWrapper[] createExecutionArray() {
        int totalInterceptors = this.actionRuntime.getInterceptors() != null ? this.actionRuntime.getInterceptors().length : 0;
        int totalFilters = this.actionRuntime.getFilters() != null ? this.actionRuntime.getFilters().length : 0;
        ActionWrapper[] executionArray = new ActionWrapper[totalFilters + 1 + totalInterceptors + 1];
        int index = 0;
        if (totalFilters > 0) {
            System.arraycopy(this.actionRuntime.getFilters(), 0, executionArray, index, totalFilters);
            index += totalFilters;
        }
        executionArray[index++] = actionRequest -> {
            Object actionResult = actionRequest.invoke();
            this.madvocController.render(this, actionResult);
            return actionResult;
        };
        if (totalInterceptors > 0) {
            System.arraycopy(this.actionRuntime.getInterceptors(), 0, executionArray, index, totalInterceptors);
            index += totalInterceptors;
        }
        executionArray[index] = actionRequest -> {
            this.actionResult = this.invokeActionMethod();
            return this.actionResult;
        };
        return executionArray;
    }

    public Object invoke() throws Exception {
        return this.executionArray[this.executionIndex++].apply(this);
    }

    protected Object invokeActionMethod() throws Exception {
        if (this.actionRuntime.isActionHandlerDefined()) {
            this.actionRuntime.getActionHandler().handle(this);
            return null;
        }
        Object[] params = this.targets.extractParametersValues();
        try {
            return this.actionRuntime.getActionClassMethod().invoke(this.action, params);
        }
        catch (InvocationTargetException itex) {
            throw ExceptionUtil.wrapToException(ExceptionUtil.unwrapThrowable(itex));
        }
    }

    public String readRequestBody() {
        if (this.requestBody == null) {
            try {
                this.requestBody = ServletUtil.readRequestBodyFromStream(this.getHttpServletRequest());
            }
            catch (IOException ioex) {
                this.requestBody = "";
            }
        }
        return this.requestBody;
    }
}

