/*
 * Decompiled with CFR 0.152.
 */
package jodd.log.impl;

import ch.qos.logback.classic.Level;
import jodd.log.Logger;
import jodd.log.LoggerProvider;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogger
implements Logger {
    public static final LoggerProvider<Slf4jLogger> PROVIDER = name -> new Slf4jLogger(LoggerFactory.getLogger((String)name));
    private static final String FQCN = Slf4jLogger.class.getName();
    final org.slf4j.Logger logger;
    private final LocationAwareLogger locationAwareLogger;

    public Slf4jLogger(org.slf4j.Logger logger) {
        this.logger = logger;
        this.locationAwareLogger = logger instanceof LocationAwareLogger ? (LocationAwareLogger)logger : null;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        switch (level) {
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void log(Logger.Level level, String message) {
        switch (level) {
            case TRACE: {
                this.trace(message);
                break;
            }
            case DEBUG: {
                this.debug(message);
                break;
            }
            case INFO: {
                this.info(message);
                break;
            }
            case WARN: {
                this.warn(message);
                break;
            }
            case ERROR: {
                this.error(message);
            }
        }
    }

    @Override
    public void log(Logger.Level level, String message, Throwable throwable) {
        switch (level) {
            case TRACE: {
                this.trace(message);
                break;
            }
            case DEBUG: {
                this.debug(message);
                break;
            }
            case INFO: {
                this.info(message);
                break;
            }
            case WARN: {
                this.warn(message, throwable);
                break;
            }
            case ERROR: {
                this.error(message, throwable);
            }
        }
    }

    @Override
    public void setLevel(Logger.Level level) {
        if (this.logger instanceof ch.qos.logback.classic.Logger) {
            Level l = null;
            switch (level) {
                case TRACE: {
                    l = Level.TRACE;
                    break;
                }
                case DEBUG: {
                    l = Level.DEBUG;
                    break;
                }
                case INFO: {
                    l = Level.INFO;
                    break;
                }
                case WARN: {
                    l = Level.WARN;
                    break;
                }
                case ERROR: {
                    l = Level.WARN;
                }
            }
            ((ch.qos.logback.classic.Logger)this.logger).setLevel(l);
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String message) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 0, message, null, null);
        } else {
            this.logger.trace(message);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String message) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 10, message, null, null);
        } else {
            this.logger.debug(message);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String message) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 20, message, null, null);
        } else {
            this.logger.info(message);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String message) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 30, message, null, null);
        } else {
            this.logger.warn(message);
        }
    }

    @Override
    public void warn(String message, Throwable throwable) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 30, message, null, throwable);
        } else {
            this.logger.warn(message, throwable);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String message) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 40, message, null, null);
        } else {
            this.logger.error(message);
        }
    }

    @Override
    public void error(String message, Throwable throwable) {
        if (this.locationAwareLogger != null) {
            this.locationAwareLogger.log(null, FQCN, 40, message, null, throwable);
        } else {
            this.logger.error(message, throwable);
        }
    }
}

