/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import jodd.json.JsonArray;
import jodd.json.JsonException;
import jodd.json.JsonSerializer;
import jodd.util.collection.MapEntry;

public class JsonObject
implements Iterable<Map.Entry<String, Object>> {
    private Map<String, Object> map;

    public JsonObject() {
        this.map = new LinkedHashMap<String, Object>();
    }

    public JsonObject(Map<String, Object> map) {
        this.map = map;
    }

    public String getString(String key) {
        CharSequence cs = (CharSequence)this.map.get(key);
        return cs == null ? null : cs.toString();
    }

    public Integer getInteger(String key) {
        Number number = (Number)this.map.get(key);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    public Long getLong(String key) {
        Number number = (Number)this.map.get(key);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return number.longValue();
    }

    public Double getDouble(String key) {
        Number number = (Number)this.map.get(key);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public Float getFloat(String key) {
        Number number = (Number)this.map.get(key);
        if (number == null) {
            return null;
        }
        if (number instanceof Float) {
            return (Float)number;
        }
        return Float.valueOf(number.floatValue());
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.map.get(key);
    }

    public JsonObject getJsonObject(String key) {
        Object val = this.map.get(key);
        if (val instanceof Map) {
            val = new JsonObject((Map)val);
        }
        return (JsonObject)val;
    }

    public JsonArray getJsonArray(String key) {
        Object val = this.map.get(key);
        if (val instanceof List) {
            val = new JsonArray((List)val);
        }
        return (JsonArray)val;
    }

    public byte[] getBinary(String key) {
        String encoded = (String)this.map.get(key);
        return encoded == null ? null : Base64.getDecoder().decode(encoded);
    }

    public <T> T getValue(String key) {
        Object val = this.map.get(key);
        if (val instanceof Map) {
            return (T)new JsonObject((Map)val);
        }
        if (val instanceof List) {
            return (T)new JsonArray((List)val);
        }
        return (T)val;
    }

    public String getString(String key, String def) {
        String val = this.getString(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        return val;
    }

    public Integer getInteger(String key, Integer def) {
        Integer val = this.getInteger(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        return val;
    }

    public Long getLong(String key, Long def) {
        Long val = this.getLong(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        return val;
    }

    public Double getDouble(String key, Double def) {
        Double val = this.getDouble(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        return val;
    }

    public Float getFloat(String key, Float def) {
        Float val = this.getFloat(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        return val;
    }

    public Boolean getBoolean(String key, Boolean def) {
        Boolean val = this.getBoolean(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        return val;
    }

    public JsonObject getJsonObject(String key, JsonObject def) {
        JsonObject val = this.getJsonObject(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        return val;
    }

    public JsonArray getJsonArray(String key, JsonArray def) {
        JsonArray val = this.getJsonArray(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        return val;
    }

    public byte[] getBinary(String key, byte[] def) {
        byte[] val = this.getBinary(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        return val;
    }

    public <T> T getValue(String key, T def) {
        T val = this.getValue(key);
        if (val == null) {
            if (this.map.containsKey(key)) {
                return null;
            }
            return def;
        }
        return val;
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public Set<String> fieldNames() {
        return this.map.keySet();
    }

    public JsonObject put(String key, Enum value) {
        Objects.requireNonNull(key);
        this.map.put(key, value == null ? null : value.name());
        return this;
    }

    public JsonObject put(String key, CharSequence value) {
        Objects.requireNonNull(key);
        this.map.put(key, value == null ? null : value.toString());
        return this;
    }

    public JsonObject put(String key, String value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, Integer value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, Long value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, Double value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, Float value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, Boolean value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject putNull(String key) {
        Objects.requireNonNull(key);
        this.map.put(key, null);
        return this;
    }

    public JsonObject put(String key, JsonObject value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, JsonArray value) {
        Objects.requireNonNull(key);
        this.map.put(key, value);
        return this;
    }

    public JsonObject put(String key, byte[] value) {
        Objects.requireNonNull(key);
        this.map.put(key, value == null ? null : Base64.getEncoder().encodeToString(value));
        return this;
    }

    public JsonObject put(String key, Object value) {
        Objects.requireNonNull(key);
        value = JsonObject.resolveValue(value);
        this.map.put(key, value);
        return this;
    }

    static Object resolveValue(Object value) {
        if (!(value == null || value instanceof Number || value instanceof Boolean || value instanceof String || value instanceof Character)) {
            if (value instanceof CharSequence) {
                value = value.toString();
            } else if (!(value instanceof JsonObject) && !(value instanceof JsonArray)) {
                if (value instanceof Map) {
                    value = new JsonObject((Map)value);
                } else if (value instanceof List) {
                    value = new JsonArray((List)value);
                } else if (value instanceof byte[]) {
                    value = Base64.getEncoder().encodeToString((byte[])value);
                } else {
                    throw new JsonException("Illegal JSON type: " + value.getClass());
                }
            }
        }
        return value;
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public JsonObject mergeIn(JsonObject other) {
        return this.mergeIn(other, 1);
    }

    public JsonObject mergeInDeep(JsonObject other) {
        return this.mergeIn(other, Integer.MAX_VALUE);
    }

    public JsonObject mergeIn(JsonObject other, int depth) {
        if (depth < 1) {
            return this;
        }
        if (depth == 1) {
            this.map.putAll(other.map);
            return this;
        }
        for (Map.Entry<String, Object> e : other.map.entrySet()) {
            this.map.merge(e.getKey(), e.getValue(), (oldVal, newVal) -> {
                if (oldVal instanceof Map) {
                    oldVal = new JsonObject((Map)oldVal);
                }
                if (newVal instanceof Map) {
                    newVal = new JsonObject((Map)newVal);
                }
                if (oldVal instanceof JsonObject && newVal instanceof JsonObject) {
                    return ((JsonObject)oldVal).mergeIn((JsonObject)newVal, depth - 1);
                }
                return newVal;
            });
        }
        return this;
    }

    public Map<String, Object> map() {
        return this.map;
    }

    public Stream<Map.Entry<String, Object>> stream() {
        return this.map.entrySet().stream();
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new Iter(this.map.entrySet().iterator());
    }

    public int size() {
        return this.map.size();
    }

    public JsonObject clear() {
        this.map.clear();
        return this;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return JsonSerializer.create().deep(true).serialize(this.map);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return JsonObject.objectEquals(this.map, o);
    }

    static boolean objectEquals(Map<?, ?> m1, Object o2) {
        Map m2;
        if (o2 instanceof JsonObject) {
            m2 = ((JsonObject)o2).map;
        } else if (o2 instanceof Map) {
            m2 = (Map)o2;
        } else {
            return false;
        }
        if (m1.size() != m2.size()) {
            return false;
        }
        for (Map.Entry<?, ?> entry : m1.entrySet()) {
            Object val = entry.getValue();
            if (!(val == null ? m2.get(entry.getKey()) != null : !JsonObject.elementEquals(entry.getValue(), m2.get(entry.getKey())))) continue;
            return false;
        }
        return true;
    }

    static boolean elementEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof JsonObject) {
            return JsonObject.objectEquals(((JsonObject)o1).map, o2);
        }
        if (o1 instanceof Map) {
            return JsonObject.objectEquals((Map)o1, o2);
        }
        if (o1 instanceof JsonArray) {
            return JsonArray.arrayEquals(((JsonArray)o1).list(), o2);
        }
        if (o1 instanceof List) {
            return JsonArray.arrayEquals((List)o1, o2);
        }
        if (o1 instanceof Number && o2 instanceof Number && o1.getClass() != o2.getClass()) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            if (o1 instanceof Float || o1 instanceof Double || o2 instanceof Float || o2 instanceof Double) {
                return n1.doubleValue() == n2.doubleValue();
            }
            return n1.longValue() == n2.longValue();
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    private class Iter
    implements Iterator<Map.Entry<String, Object>> {
        final Iterator<Map.Entry<String, Object>> mapIterator;

        Iter(Iterator<Map.Entry<String, Object>> mapIterator) {
            this.mapIterator = mapIterator;
        }

        @Override
        public boolean hasNext() {
            return this.mapIterator.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            Map.Entry<String, Object> entry = this.mapIterator.next();
            if (entry.getValue() instanceof Map) {
                return MapEntry.createUnmodifiable(entry.getKey(), new JsonObject((Map)entry.getValue()));
            }
            if (entry.getValue() instanceof List) {
                return MapEntry.createUnmodifiable(entry.getKey(), new JsonArray((List)entry.getValue()));
            }
            return entry;
        }

        @Override
        public void remove() {
            this.mapIterator.remove();
        }
    }
}

