/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.dao;

import java.util.List;
import jodd.bean.BeanUtil;
import jodd.db.DbOom;
import jodd.db.DbQuery;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbOomException;
import jodd.db.oom.DbOomQuery;

public class GenericDao {
    private final DbOom dbOom;

    public GenericDao(DbOom dbOom) {
        this.dbOom = dbOom;
    }

    protected <E> boolean isPersistent(DbEntityDescriptor<E> ded, E entity) {
        long value;
        Object key = ded.getIdValue(entity);
        if (key == null) {
            return false;
        }
        return !(key instanceof Number) || (value = ((Number)key).longValue()) != 0L;
    }

    protected <E, ID> void setEntityId(DbEntityDescriptor<E> ded, E entity, ID newIdValue) {
        ded.setIdValue(entity, newIdValue);
    }

    protected <ID> ID generateNextId(DbEntityDescriptor dbEntityDescriptor) {
        throw new UnsupportedOperationException("Use Joy");
    }

    public <E> E store(E entity) {
        Class<?> type = entity.getClass();
        DbEntityDescriptor<?> ded = this.dbOom.entityManager().lookupType(type);
        if (ded == null) {
            throw new DbOomException("Not an entity: " + type);
        }
        if (!this.isPersistent(ded, entity)) {
            DbOomQuery q;
            if (this.dbOom.config().isKeysGeneratedByDatabase()) {
                q = DbOomQuery.query(this.dbOom.entities().insert(entity));
                q.setGeneratedKey();
                q.executeUpdate();
                Long nextId = q.getGeneratedKey();
                this.setEntityId(ded, entity, nextId);
            } else {
                Object nextId = this.generateNextId(ded);
                this.setEntityId(ded, entity, nextId);
                q = DbOomQuery.query(this.dbOom.entities().insert(entity));
                q.executeUpdate();
            }
            q.close();
        } else {
            DbOomQuery.query(this.dbOom.entities().updateAll(entity)).autoClose().executeUpdate();
        }
        return entity;
    }

    public void save(Object entity) {
        DbOomQuery q = DbOomQuery.query(this.dbOom.entities().insert(entity));
        ((DbQuery)((DbQuery)q).autoClose()).executeUpdate();
    }

    public void saveAll(Iterable entities) {
        for (Object entity : entities) {
            this.save(entity);
        }
    }

    public void update(Object entity) {
        DbOomQuery.query(this.dbOom.entities().updateAll(entity)).autoClose().executeUpdate();
    }

    public void updateAll(Iterable entities) {
        for (Object entity : entities) {
            this.update(entity);
        }
    }

    public <E> E updateProperty(E entity, String name, Object newValue) {
        DbOomQuery.query(this.dbOom.entities().updateColumn(entity, name, newValue)).autoClose().executeUpdate();
        BeanUtil.declared.setProperty(entity, name, newValue);
        return entity;
    }

    public <E> E updateProperty(E entity, String name) {
        Object value = BeanUtil.declared.getProperty(entity, name);
        DbOomQuery.query(this.dbOom.entities().updateColumn(entity, name, value)).autoClose().executeUpdate();
        return entity;
    }

    public <E, ID> E findById(Class<E> entityType, ID id) {
        return (E)DbOomQuery.query(this.dbOom.entities().findById(entityType, id)).autoClose().find(entityType);
    }

    public <E> E findOneByProperty(Class<E> entityType, String name, Object value) {
        return (E)DbOomQuery.query(this.dbOom.entities().findByColumn(entityType, name, value)).autoClose().find(entityType);
    }

    public <E> E findOne(Object criteria) {
        return (E)DbOomQuery.query(this.dbOom.entities().find(criteria)).autoClose().find(criteria.getClass());
    }

    public <E> List<E> find(Object criteria) {
        return DbOomQuery.query(this.dbOom.entities().find(criteria)).autoClose().list(criteria.getClass());
    }

    public <E> List<E> find(Class<E> entityType, Object criteria) {
        return DbOomQuery.query(this.dbOom.entities().find(entityType, criteria)).autoClose().list(entityType);
    }

    public <ID> void deleteById(Class entityType, ID id) {
        DbOomQuery.query(this.dbOom.entities().deleteById(entityType, id)).autoClose().executeUpdate();
    }

    public void deleteById(Object entity) {
        int result;
        if (entity != null && (result = DbOomQuery.query(this.dbOom.entities().deleteById(entity)).autoClose().executeUpdate()) != 0) {
            Class<?> type = entity.getClass();
            DbEntityDescriptor<?> ded = this.dbOom.entityManager().lookupType(type);
            this.setEntityId(ded, entity, 0);
        }
    }

    public void deleteAllById(Iterable objects) {
        for (Object entity : objects) {
            this.deleteById(entity);
        }
    }

    public long count(Class entityType) {
        return DbOomQuery.query(this.dbOom.entities().count(entityType)).autoClose().executeCount();
    }

    public <ID> void increaseProperty(Class entityType, ID id, String name, Number delta) {
        DbOomQuery.query(this.dbOom.entities().increaseColumn(entityType, id, name, delta, true)).autoClose().executeUpdate();
    }

    public <ID> void decreaseProperty(Class entityType, ID id, String name, Number delta) {
        DbOomQuery.query(this.dbOom.entities().increaseColumn(entityType, id, name, delta, false)).autoClose().executeUpdate();
    }

    public <E> List<E> findRelated(Class<E> target, Object source) {
        return DbOomQuery.query(this.dbOom.entities().findForeign(target, source)).autoClose().list(target);
    }

    public <E> List<E> listAll(Class<E> target) {
        return DbOomQuery.query(this.dbOom.entities().from(target)).autoClose().list(target);
    }
}

