/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.bean.BeanUtil;
import jodd.db.DbOom;
import jodd.db.DbQuery;
import jodd.db.DbSession;
import jodd.db.DbUtil;
import jodd.db.oom.ColumnData;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbListIterator;
import jodd.db.oom.DbSqlGenerator;
import jodd.db.oom.JoinHintResolver;
import jodd.db.oom.mapper.DefaultResultSetMapper;
import jodd.db.oom.mapper.ResultSetMapper;
import jodd.db.oom.sqlgen.ParameterValue;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.util.CharUtil;
import jodd.util.StringUtil;

public class DbOomQuery
extends DbQuery<DbOomQuery> {
    private static final Logger log = LoggerFactory.getLogger(DbOomQuery.class);
    protected final DbSqlGenerator sqlgen;
    protected JoinHintResolver hintResolver;
    protected String[] hints;
    protected boolean cacheEntities;
    protected boolean entityAwareMode;

    public DbOomQuery(DbOom dbOom, Connection conn, String sqlString) {
        super(dbOom, conn, sqlString);
        this.sqlgen = null;
        this.init(dbOom);
    }

    public static DbOomQuery query(Connection conn, String sqlString) {
        return new DbOomQuery(DbOom.get(), conn, sqlString);
    }

    public DbOomQuery(DbOom dbOom, DbSession session, String sqlString) {
        super(dbOom, session, sqlString);
        this.sqlgen = null;
        this.init(dbOom);
    }

    public static DbOomQuery query(DbSession session, String sqlString) {
        return new DbOomQuery(DbOom.get(), session, sqlString);
    }

    public DbOomQuery(DbOom dbOom, String sqlString) {
        super(dbOom, sqlString);
        this.sqlgen = null;
        this.init(dbOom);
    }

    public static DbOomQuery query(String sqlString) {
        return new DbOomQuery(DbOom.get(), sqlString);
    }

    public DbOomQuery(DbOom dbOom, Connection conn, DbSqlGenerator sqlgen) {
        super(dbOom, conn, sqlgen.generateQuery());
        this.sqlgen = sqlgen;
        this.init(dbOom);
    }

    public static DbOomQuery query(Connection conn, DbSqlGenerator sqlgen) {
        return new DbOomQuery(DbOom.get(), conn, sqlgen);
    }

    public DbOomQuery(DbOom dbOom, DbSession session, DbSqlGenerator sqlgen) {
        super(dbOom, session, sqlgen.generateQuery());
        this.sqlgen = sqlgen;
        this.init(dbOom);
    }

    public static DbOomQuery query(DbSession session, DbSqlGenerator sqlgen) {
        return new DbOomQuery(DbOom.get(), session, sqlgen);
    }

    public DbOomQuery(DbOom dbOom, DbSqlGenerator sqlgen) {
        super(dbOom, sqlgen.generateQuery());
        this.sqlgen = sqlgen;
        this.init(dbOom);
    }

    public static DbOomQuery query(DbSqlGenerator sqlgen) {
        return new DbOomQuery(DbOom.get(), sqlgen);
    }

    protected void init(DbOom dbOom) {
        this.sqlString = this.preprocessSql(this.sqlString);
        this.cacheEntities = dbOom.config().isCacheEntitiesInResultSet();
        this.entityAwareMode = dbOom.config().isEntityAwareMode();
    }

    @Override
    protected void prepareQuery() {
        Map<String, ParameterValue> parameters;
        String[] joinHints;
        super.prepareQuery();
        if (this.sqlgen == null) {
            return;
        }
        if (this.hints == null && (joinHints = this.sqlgen.getJoinHints()) != null) {
            this.withHints(joinHints);
        }
        if ((parameters = this.sqlgen.getQueryParameters()) == null) {
            return;
        }
        for (Map.Entry<String, ParameterValue> entry : parameters.entrySet()) {
            String paramName = entry.getKey();
            ParameterValue param = entry.getValue();
            DbEntityColumnDescriptor dec = param.getColumnDescriptor();
            if (dec == null) {
                this.setObject(paramName, param.getValue());
                continue;
            }
            this.resolveColumnDbSqlType(this.connection, dec);
            this.setObject(paramName, param.getValue(), dec.getSqlTypeClass(), dec.getDbSqlType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveColumnDbSqlType(Connection connection, DbEntityColumnDescriptor dec) {
        if (dec.dbSqlType != Integer.MAX_VALUE) {
            return;
        }
        ResultSet rs = null;
        DbEntityDescriptor ded = dec.getDbEntityDescriptor();
        try {
            DatabaseMetaData dmd = connection.getMetaData();
            rs = dmd.getColumns(null, ded.getSchemaName(), ded.getTableName(), dec.getColumnName());
            if (rs.next()) {
                dec.dbSqlType = rs.getInt("DATA_TYPE");
            } else {
                dec.dbSqlType = Integer.MIN_VALUE;
                if (log.isWarnEnabled()) {
                    log.warn("Column SQL type not available: " + ded.toString() + '.' + dec.getColumnName());
                }
            }
            DbUtil.close(rs);
        }
        catch (SQLException sex) {
            dec.dbSqlType = Integer.MIN_VALUE;
            if (log.isWarnEnabled()) {
                log.warn("Column SQL type not resolved: " + ded.toString() + '.' + dec.getColumnName(), (Throwable)sex);
            }
        }
        finally {
            DbUtil.close(rs);
        }
    }

    protected String preprocessSql(String sqlString) {
        if (sqlString.charAt(0) == '{') {
            return sqlString;
        }
        if (!CharUtil.isAlpha(sqlString.charAt(0))) {
            sqlString = sqlString.substring(1);
        } else if (sqlString.indexOf(32) != -1) {
            return sqlString;
        }
        String sqlFromMap = this.dbOom.queryMap().getQuery(sqlString);
        if (sqlFromMap != null) {
            sqlString = sqlFromMap.trim();
        }
        return sqlString;
    }

    public DbOomQuery withHints(String hint) {
        this.hints = StringUtil.splitc(hint, ',');
        return this;
    }

    public DbOomQuery withHints(String ... hints) {
        this.hints = hints;
        return this;
    }

    protected Object resolveRowResults(Object[] row) {
        if (this.hintResolver == null) {
            this.hintResolver = new JoinHintResolver();
        }
        return (row = this.hintResolver.join(row, this.hints)).length == 1 ? row[0] : row;
    }

    public DbOomQuery cacheEntities(boolean cacheEntities) {
        this.cacheEntities = cacheEntities;
        return this;
    }

    protected ResultSetMapper executeAndBuildResultSetMapper() {
        ResultSet resultSet = this.execute();
        return this.createResultSetMapper(resultSet);
    }

    protected ResultSetMapper createResultSetMapper(ResultSet resultSet) {
        Map<String, ColumnData> columnAliases = this.sqlgen != null ? this.sqlgen.getColumnData() : null;
        return new DefaultResultSetMapper(this.dbOom, resultSet, columnAliases, this.cacheEntities, this);
    }

    public DbOomQuery entityAwareMode(boolean entityAware) {
        if (entityAware) {
            this.cacheEntities = true;
        }
        this.entityAwareMode = entityAware;
        return this;
    }

    public <T> Iterator<T> iterate(Class ... types) {
        return this.iterate(types, this.autoClose);
    }

    public <T> Iterator<T> iterate() {
        return this.iterate(null, this.autoClose);
    }

    protected <T> Iterator<T> iterate(Class[] types, boolean close) {
        return new DbListIterator(this, types, close);
    }

    public <T> List<T> list(Class ... types) {
        return this.list(types, -1, this.autoClose);
    }

    public <T> List<T> list() {
        return this.list(null, -1, this.autoClose);
    }

    public <T> List<T> list(int max, Class ... types) {
        return this.list(types, max, this.autoClose);
    }

    public <T> List<T> list(int max) {
        return this.list(null, max, this.autoClose);
    }

    protected <T> List<T> list(Class[] types, int max, boolean close) {
        ArrayList<Object> result = new ArrayList<Object>(DbOomQuery.initialCollectionSize(max));
        ResultSetMapper rsm = this.executeAndBuildResultSetMapper();
        if (types == null) {
            types = rsm.resolveTables();
        }
        Object previousElement = null;
        while (rsm.next()) {
            boolean equals;
            Object[] objects = rsm.parseObjects(types);
            Object row = this.resolveRowResults(objects);
            int size = result.size();
            Object newElement = row;
            if (this.entityAwareMode && size > 0 && previousElement != null && newElement != null && (equals = newElement.getClass().isArray() ? Arrays.equals((Object[])previousElement, (Object[])newElement) : previousElement.equals(newElement))) continue;
            if (size == max) break;
            result.add(newElement);
            previousElement = newElement;
        }
        this.close(rsm, close);
        return result;
    }

    private static int initialCollectionSize(int max) {
        return max > 0 ? max : 10;
    }

    public <T> Set<T> listSet(Class ... types) {
        return this.listSet(types, -1, this.autoClose);
    }

    public <T> Set<T> listSet() {
        return this.listSet(null, -1, this.autoClose);
    }

    public <T> Set<T> listSet(int max, Class ... types) {
        return this.listSet(types, max, this.autoClose);
    }

    public <T> Set<T> listSet(int max) {
        return this.listSet(null, max, this.autoClose);
    }

    protected <T> Set<T> listSet(Class[] types, int max, boolean close) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(DbOomQuery.initialCollectionSize(max));
        ResultSetMapper rsm = this.executeAndBuildResultSetMapper();
        if (types == null) {
            types = rsm.resolveTables();
        }
        Object previousElement = null;
        while (rsm.next()) {
            boolean equals;
            Object[] objects = rsm.parseObjects(types);
            Object row = this.resolveRowResults(objects);
            int size = result.size();
            Object newElement = row;
            if (this.entityAwareMode && size > 0 && previousElement != null && newElement != null && (equals = newElement.getClass().isArray() ? Arrays.equals((Object[])previousElement, (Object[])newElement) : previousElement.equals(newElement))) continue;
            if (size == max) break;
            result.add(newElement);
            previousElement = newElement;
        }
        this.close(rsm, close);
        return result;
    }

    public <T> T find(Class ... types) {
        return this.find(types, this.autoClose, null);
    }

    public <T> T find() {
        return this.find(null, this.autoClose, null);
    }

    protected <T> T find(Class[] types, boolean close, ResultSet resultSet) {
        if (resultSet == null) {
            resultSet = this.execute();
        }
        ResultSetMapper rsm = this.createResultSetMapper(resultSet);
        DbListIterator iterator = new DbListIterator(this, types, rsm, false);
        T result = null;
        if (iterator.hasNext()) {
            result = (T)iterator.next();
        }
        this.close(rsm, close);
        return result;
    }

    public <T> T findGeneratedKey(Class<T> type) {
        return this.find(new Class[]{type}, false, this.getGeneratedColumns());
    }

    public Object findGeneratedColumns(Class ... types) {
        return this.find(types, false, this.getGeneratedColumns());
    }

    public void populateGeneratedKeys(Object entity) {
        String[] generatedColumns = this.getGeneratedColumnNames();
        if (generatedColumns == null) {
            return;
        }
        DbEntityDescriptor<?> ded = this.dbOom.entityManager().lookupType(entity.getClass());
        Class[] keyTypes = new Class[generatedColumns.length];
        String[] properties = new String[generatedColumns.length];
        for (int i = 0; i < generatedColumns.length; ++i) {
            String column = generatedColumns[i];
            DbEntityColumnDescriptor decd = ded.findByColumnName(column);
            if (decd == null) continue;
            keyTypes[i] = decd.getPropertyType();
            properties[i] = decd.getPropertyName();
        }
        Object keyValues = this.findGeneratedColumns(keyTypes);
        if (!keyValues.getClass().isArray()) {
            BeanUtil.declared.setProperty(entity, properties[0], keyValues);
        } else {
            for (int i = 0; i < properties.length; ++i) {
                BeanUtil.declared.setProperty(entity, properties[i], ((Object[])keyValues)[i]);
            }
        }
    }

    @Override
    public DbOomQuery autoClose() {
        super.autoClose();
        return this;
    }

    protected void close(ResultSetMapper rsm, boolean closeQuery) {
        if (closeQuery) {
            this.close();
        } else {
            this.closeResultSet(rsm.getResultSet());
        }
    }
}

