/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.money.CurrencyUnitDataProvider;

class DefaultCurrencyUnitDataProvider
extends CurrencyUnitDataProvider {
    private static final Pattern REGEX_LINE = Pattern.compile("([A-Z]{3}),(-1|[0-9]{1,3}),(-1|[0-9]),([A-Z]*)#?.*");

    DefaultCurrencyUnitDataProvider() {
    }

    @Override
    protected void registerCurrencies() throws Exception {
        this.loadCurrenciesFromFile("/org/joda/money/MoneyData.csv", true);
        this.loadCurrenciesFromFile("/org/joda/money/MoneyDataExtension.csv", false);
    }

    private void loadCurrenciesFromFile(String fileName, boolean isNecessary) throws Exception {
        String line;
        InputStream in = this.getClass().getResourceAsStream(fileName);
        if (in == null && isNecessary) {
            throw new FileNotFoundException("Data file " + fileName + " not found");
        }
        if (in == null && !isNecessary) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        while ((line = reader.readLine()) != null) {
            Matcher matcher = REGEX_LINE.matcher(line);
            if (!matcher.matches()) continue;
            ArrayList<String> countryCodes = new ArrayList<String>();
            String codeStr = matcher.group(4);
            String currencyCode = matcher.group(1);
            if (codeStr.length() % 2 == 1) continue;
            for (int i = 0; i < codeStr.length(); i += 2) {
                countryCodes.add(codeStr.substring(i, i + 2));
            }
            int numericCode = Integer.parseInt(matcher.group(2));
            int digits = Integer.parseInt(matcher.group(3));
            this.registerCurrency(currencyCode, numericCode, digits, countryCodes);
        }
    }
}

