/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money.format;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.joda.money.BigMoney;
import org.joda.money.BigMoneyProvider;
import org.joda.money.Money;
import org.joda.money.format.MoneyFormatException;
import org.joda.money.format.MoneyFormatterBuilder;
import org.joda.money.format.MoneyParseContext;
import org.joda.money.format.MoneyParser;
import org.joda.money.format.MoneyPrintContext;
import org.joda.money.format.MoneyPrinter;

public final class MoneyFormatter
implements Serializable {
    private static final long serialVersionUID = 2385346258L;
    private final Locale locale;
    private final MoneyPrinter[] printers;
    private final MoneyParser[] parsers;

    static void checkNotNull(Object object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
    }

    MoneyFormatter(Locale locale, MoneyPrinter[] printers, MoneyParser[] parsers) {
        assert (locale != null);
        assert (printers != null);
        assert (parsers != null);
        assert (printers.length == parsers.length);
        this.locale = locale;
        this.printers = printers;
        this.parsers = parsers;
    }

    void appendTo(MoneyFormatterBuilder builder) {
        for (int i = 0; i < this.printers.length; ++i) {
            builder.append(this.printers[i], this.parsers[i]);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public MoneyFormatter withLocale(Locale locale) {
        MoneyFormatter.checkNotNull(locale, "Locale must not be null");
        return new MoneyFormatter(locale, this.printers, this.parsers);
    }

    public boolean isPrinter() {
        return !Arrays.asList(this.printers).contains(null);
    }

    public boolean isParser() {
        return !Arrays.asList(this.parsers).contains(null);
    }

    public String print(BigMoneyProvider moneyProvider) {
        StringBuilder buf = new StringBuilder();
        this.print(buf, moneyProvider);
        return buf.toString();
    }

    public void print(Appendable appendable, BigMoneyProvider moneyProvider) {
        try {
            this.printIO(appendable, moneyProvider);
        }
        catch (IOException ex) {
            throw new MoneyFormatException(ex.getMessage(), ex);
        }
    }

    public void printIO(Appendable appendable, BigMoneyProvider moneyProvider) throws IOException {
        MoneyFormatter.checkNotNull(moneyProvider, "BigMoneyProvider must not be null");
        if (!this.isPrinter()) {
            throw new UnsupportedOperationException("MoneyFomatter has not been configured to be able to print");
        }
        BigMoney money = BigMoney.of(moneyProvider);
        MoneyPrintContext context = new MoneyPrintContext(this.locale);
        for (MoneyPrinter printer : this.printers) {
            printer.print(context, appendable, money);
        }
    }

    public BigMoney parseBigMoney(CharSequence text) {
        MoneyFormatter.checkNotNull(text, "Text must not be null");
        MoneyParseContext result = this.parse(text, 0);
        if (result.isError() || !result.isFullyParsed() || !result.isComplete()) {
            String str;
            String string = str = text.length() > 64 ? ((Object)text.subSequence(0, 64)).toString() + "..." : ((Object)text).toString();
            if (result.isError()) {
                throw new MoneyFormatException("Text could not be parsed at index " + result.getErrorIndex() + ": " + str);
            }
            if (!result.isFullyParsed()) {
                throw new MoneyFormatException("Unparsed text found at index " + result.getIndex() + ": " + str);
            }
            throw new MoneyFormatException("Parsing did not find both currency and amount: " + str);
        }
        return result.toBigMoney();
    }

    public Money parseMoney(CharSequence text) {
        return this.parseBigMoney(text).toMoney();
    }

    public MoneyParseContext parse(CharSequence text, int startIndex) {
        MoneyFormatter.checkNotNull(text, "Text must not be null");
        if (startIndex < 0 || startIndex > text.length()) {
            throw new StringIndexOutOfBoundsException("Invalid start index: " + startIndex);
        }
        if (!this.isParser()) {
            throw new UnsupportedOperationException("MoneyFomatter has not been configured to be able to parse");
        }
        MoneyParseContext context = new MoneyParseContext(this.locale, text, startIndex);
        for (MoneyParser parser : this.parsers) {
            parser.parse(context);
            if (context.isError()) break;
        }
        return context;
    }

    public String toString() {
        StringBuilder buf1 = new StringBuilder();
        if (this.isPrinter()) {
            for (MoneyPrinter printer : this.printers) {
                buf1.append(printer.toString());
            }
        }
        StringBuilder buf2 = new StringBuilder();
        if (this.isParser()) {
            for (MoneyParser parser : this.parsers) {
                buf2.append(parser.toString());
            }
        }
        String str1 = buf1.toString();
        String str2 = buf2.toString();
        if (this.isPrinter() && !this.isParser()) {
            return str1;
        }
        if (this.isParser() && !this.isPrinter()) {
            return str2;
        }
        if (str1.equals(str2)) {
            return str1;
        }
        return str1 + ":" + str2;
    }
}

