/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money.format;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import org.joda.money.BigMoney;
import org.joda.money.MoneyUtils;
import org.joda.money.format.MoneyAmountStyle;
import org.joda.money.format.MoneyParseContext;
import org.joda.money.format.MoneyParser;
import org.joda.money.format.MoneyPrintContext;
import org.joda.money.format.MoneyPrinter;

final class AmountPrinterParser
implements MoneyPrinter,
MoneyParser,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MoneyAmountStyle style;

    AmountPrinterParser(MoneyAmountStyle style) {
        this.style = style;
    }

    public void print(MoneyPrintContext context, Appendable appendable, BigMoney money) throws IOException {
        MoneyAmountStyle activeStyle = this.style.localize(context.getLocale());
        if (MoneyUtils.isNegative(money)) {
            money = money.negated();
            appendable.append(activeStyle.getNegativeSignCharacter().charValue());
        }
        String str = money.getAmount().toPlainString();
        char zeroChar = activeStyle.getZeroCharacter().charValue();
        if (zeroChar != '0') {
            int diff = zeroChar - 48;
            StringBuilder zeroConvert = new StringBuilder(str);
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (ch < '0' || ch > '9') continue;
                zeroConvert.setCharAt(i, (char)(ch + diff));
            }
            str = zeroConvert.toString();
        }
        int decPoint = str.indexOf(46);
        if (activeStyle.isGrouping()) {
            int groupingSize = activeStyle.getGroupingSize();
            char groupingChar = activeStyle.getGroupingCharacter().charValue();
            int post = decPoint < 0 ? 0 : str.length() - decPoint - 1;
            int i = 0;
            for (int pre = decPoint < 0 ? str.length() : decPoint; pre > 0; --pre) {
                appendable.append(str.charAt(i));
                if (pre > 3 && pre % groupingSize == 1) {
                    appendable.append(groupingChar);
                }
                ++i;
            }
            if (decPoint >= 0 || activeStyle.isForcedDecimalPoint()) {
                appendable.append(activeStyle.getDecimalPointCharacter().charValue());
            }
            ++decPoint;
            for (i = 0; i < post; ++i) {
                appendable.append(str.charAt(i + decPoint));
                if (i % groupingSize != 2) continue;
                appendable.append(groupingChar);
            }
        } else if (decPoint < 0) {
            appendable.append(str);
            if (activeStyle.isForcedDecimalPoint()) {
                appendable.append(activeStyle.getDecimalPointCharacter().charValue());
            }
        } else {
            appendable.append(str.subSequence(0, decPoint)).append(activeStyle.getDecimalPointCharacter().charValue()).append(str.substring(decPoint + 1));
        }
    }

    public void parse(MoneyParseContext context) {
        char ch;
        int len = context.getTextLength();
        MoneyAmountStyle activeStyle = this.style.localize(context.getLocale());
        char[] buf = new char[len - context.getIndex()];
        int bufPos = 0;
        boolean dpSeen = false;
        boolean lastWasGroup = false;
        int pos = context.getIndex();
        if (pos < len) {
            ch = context.getText().charAt(pos++);
            if (ch == activeStyle.getNegativeSignCharacter().charValue()) {
                buf[bufPos++] = 45;
            } else if (ch == activeStyle.getPositiveSignCharacter().charValue()) {
                buf[bufPos++] = 43;
            } else if (ch >= activeStyle.getZeroCharacter().charValue() && ch < activeStyle.getZeroCharacter().charValue() + 10) {
                buf[bufPos++] = (char)(48 + ch - activeStyle.getZeroCharacter().charValue());
            } else if (ch == activeStyle.getDecimalPointCharacter().charValue()) {
                buf[bufPos++] = 46;
                dpSeen = true;
            } else {
                context.setError();
                return;
            }
        }
        while (pos < len) {
            ch = context.getText().charAt(pos);
            if (ch >= activeStyle.getZeroCharacter().charValue() && ch < activeStyle.getZeroCharacter().charValue() + 10) {
                buf[bufPos++] = (char)(48 + ch - activeStyle.getZeroCharacter().charValue());
                lastWasGroup = false;
            } else if (ch == activeStyle.getDecimalPointCharacter().charValue() && !dpSeen) {
                buf[bufPos++] = 46;
                dpSeen = true;
                lastWasGroup = false;
            } else {
                if (ch != activeStyle.getGroupingCharacter().charValue() || lastWasGroup) break;
                lastWasGroup = true;
            }
            ++pos;
        }
        if (lastWasGroup) {
            --pos;
        }
        try {
            context.setAmount(new BigDecimal(buf, 0, bufPos));
            context.setIndex(pos);
        }
        catch (NumberFormatException ex) {
            context.setError();
        }
    }

    public String toString() {
        return "${amount}";
    }
}

