/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.audio.lwjgl;

import com.jme3.audio.openal.ALC;
import java.nio.IntBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCcontext;
import org.lwjgl.openal.ALCdevice;

public class LwjglALC
implements ALC {
    private static final Logger logger = Logger.getLogger(LwjglALC.class.getName());

    public void createALC() {
        int numRetriesRemaining = 4;
        int retryDelayMsec = 100;
        while (true) {
            try {
                AL.create();
            }
            catch (LWJGLException exception1) {
                if (numRetriesRemaining < 1) {
                    throw new RuntimeException(exception1);
                }
                String message = String.format("Caught an LWJGLException from AL.create(). Will retry after %d msec, with %d more retr%s remaining.%n", retryDelayMsec, --numRetriesRemaining, numRetriesRemaining == 1 ? "y" : "ies");
                logger.log(Level.WARNING, message);
                try {
                    Thread.sleep(retryDelayMsec);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    public void destroyALC() {
        AL.destroy();
    }

    public boolean isCreated() {
        return AL.isCreated();
    }

    public String alcGetString(int parameter) {
        ALCcontext context = ALC10.alcGetCurrentContext();
        ALCdevice device = ALC10.alcGetContextsDevice((ALCcontext)context);
        return ALC10.alcGetString((ALCdevice)device, (int)parameter);
    }

    public boolean alcIsExtensionPresent(String extension) {
        ALCcontext context = ALC10.alcGetCurrentContext();
        ALCdevice device = ALC10.alcGetContextsDevice((ALCcontext)context);
        return ALC10.alcIsExtensionPresent((ALCdevice)device, (String)extension);
    }

    public void alcGetInteger(int param, IntBuffer buffer, int size) {
        if (buffer.position() != 0) {
            throw new AssertionError();
        }
        if (buffer.limit() != size) {
            throw new AssertionError();
        }
        ALCcontext context = ALC10.alcGetCurrentContext();
        ALCdevice device = ALC10.alcGetContextsDevice((ALCcontext)context);
        ALC10.alcGetInteger((ALCdevice)device, (int)param, (IntBuffer)buffer);
    }

    public void alcDevicePauseSOFT() {
    }

    public void alcDeviceResumeSOFT() {
    }
}

