/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util.struct.fields;

import com.jme3.util.struct.Struct;
import com.jme3.util.struct.StructField;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;

public class SubStructArrayField<T extends Struct>
extends StructField<T[]> {
    public SubStructArrayField(int position, String name, T[] value) {
        super(position, name, value);
        this.initializeToZero(value[0].getClass());
    }

    public SubStructArrayField(int position, String name, int length, Class<? extends T> structClass) {
        super(position, name, (Struct[])Array.newInstance(structClass, length));
        this.initializeToZero(structClass);
    }

    private void initializeToZero(Class<? extends T> structClass) {
        for (int i = 0; i < ((Struct[])this.value).length; ++i) {
            if (((Struct[])this.value)[i] != null) continue;
            try {
                Constructor<T> constructor = structClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                ((Struct[])this.value)[i] = (Struct)constructor.newInstance(new Object[0]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Can't create new instance of " + structClass + " default constructor is missing? ", e);
            }
        }
    }
}

