/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util.struct;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.shader.bufferobject.BufferObject;
import com.jme3.shader.bufferobject.layout.Std140Layout;
import com.jme3.util.struct.Struct;
import com.jme3.util.struct.StructField;
import com.jme3.util.struct.StructUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StructStd140BufferObject
extends BufferObject {
    private static final Logger logger = Logger.getLogger(StructStd140BufferObject.class.getName());
    private transient Class<? extends Struct> rootStruct;
    private transient List<StructField<?>> resolvedFields;
    private final Std140Layout std140 = new Std140Layout();

    public StructStd140BufferObject() {
    }

    public StructStd140BufferObject(int id) {
        super(id);
    }

    public StructStd140BufferObject(Struct str) {
        this();
        this.update(str);
    }

    private void loadLayout(Struct struct) {
        ArrayList<Field> classFields = new ArrayList<Field>();
        this.resolvedFields = StructUtils.getFields(struct, classFields);
        for (Field field : classFields) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            throw new RuntimeException("Can't load layout for " + struct + " every field must be final");
        }
        this.rootStruct = struct.getClass();
        StructUtils.setStd140BufferLayout(this.resolvedFields, this.std140, this);
    }

    public void update(Struct struct) {
        boolean forceUpdate = false;
        if (this.rootStruct != struct.getClass()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Change in layout {0} =/= {1} ", new Object[]{this.rootStruct, struct.getClass()});
            }
            this.loadLayout(struct);
            forceUpdate = true;
        }
        StructUtils.updateBufferData(this.resolvedFields, forceUpdate, this.std140, this);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.rootStruct.getName(), "rootClass", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        try {
            String rootClass = ic.readString("rootClass", null);
            if (rootClass == null) {
                throw new Exception("rootClass is undefined");
            }
            Class<?> rootStructClass = Class.forName(rootClass);
            Struct rootStruct = (Struct)rootStructClass.newInstance();
            this.loadLayout(rootStruct);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public StructStd140BufferObject clone() {
        StructStd140BufferObject clone = (StructStd140BufferObject)super.clone();
        return clone;
    }
}

