/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.bounding.BoundingSphere;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.TextureCubeMap;
import java.nio.ByteBuffer;

public class SkyFactory {
    private SkyFactory() {
    }

    @Deprecated
    public static Spatial createSky(AssetManager assetManager, Texture texture, Vector3f normalScale, boolean sphereMap) {
        return SkyFactory.createSky(assetManager, texture, normalScale, sphereMap, 10);
    }

    public static Spatial createSky(AssetManager assetManager, Texture texture, Vector3f normalScale, EnvMapType envMapType) {
        return SkyFactory.createSky(assetManager, texture, normalScale, envMapType, 10.0f);
    }

    @Deprecated
    public static Spatial createSky(AssetManager assetManager, Texture texture, Vector3f normalScale, boolean sphereMap, int sphereRadius) {
        return SkyFactory.createSky(assetManager, texture, normalScale, sphereMap ? EnvMapType.SphereMap : EnvMapType.CubeMap, (float)sphereRadius);
    }

    public static Spatial createSky(AssetManager assetManager, Texture texture, Vector3f normalScale, EnvMapType envMapType, float sphereRadius) {
        Material skyMat;
        if (texture == null) {
            throw new IllegalArgumentException("texture cannot be null");
        }
        Sphere sphereMesh = new Sphere(10, 10, sphereRadius, false, true);
        Geometry sky = new Geometry("Sky", sphereMesh);
        sky.setQueueBucket(RenderQueue.Bucket.Sky);
        sky.setCullHint(Spatial.CullHint.Never);
        sky.setModelBound(new BoundingSphere(Float.POSITIVE_INFINITY, Vector3f.ZERO));
        sky.setShadowMode(RenderQueue.ShadowMode.Off);
        switch (envMapType.ordinal()) {
            case 0: {
                if (!(texture instanceof TextureCubeMap)) {
                    Image img = texture.getImage();
                    texture = new TextureCubeMap();
                    texture.setImage(img);
                }
                skyMat = new Material(assetManager, "Common/MatDefs/Misc/Sky.j3md");
                break;
            }
            case 1: {
                skyMat = new Material(assetManager, "Common/MatDefs/Misc/SkyNonCube.j3md");
                skyMat.setBoolean("SphereMap", true);
                break;
            }
            case 2: {
                skyMat = new Material(assetManager, "Common/MatDefs/Misc/SkyNonCube.j3md");
                skyMat.setBoolean("EquirectMap", true);
                break;
            }
            default: {
                throw new IllegalArgumentException("envMapType=" + (Object)((Object)envMapType));
            }
        }
        skyMat.setVector3("NormalScale", normalScale);
        texture.setMagFilter(Texture.MagFilter.Bilinear);
        texture.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
        texture.setAnisotropicFilter(0);
        texture.setWrap(Texture.WrapMode.EdgeClamp);
        skyMat.setTexture("Texture", texture);
        sky.setMaterial(skyMat);
        return sky;
    }

    @Deprecated
    public static Spatial createSky(AssetManager assetManager, Texture texture, boolean sphereMap) {
        return SkyFactory.createSky(assetManager, texture, Vector3f.UNIT_XYZ, sphereMap ? EnvMapType.SphereMap : EnvMapType.CubeMap);
    }

    @Deprecated
    public static Spatial createSky(AssetManager assetManager, String textureName, boolean sphereMap) {
        return SkyFactory.createSky(assetManager, textureName, sphereMap ? EnvMapType.SphereMap : EnvMapType.CubeMap);
    }

    public static Spatial createSky(AssetManager assetManager, Texture texture, EnvMapType envMapType) {
        return SkyFactory.createSky(assetManager, texture, Vector3f.UNIT_XYZ, envMapType);
    }

    public static Spatial createSky(AssetManager assetManager, String textureName, EnvMapType envMapType) {
        TextureKey key = new TextureKey(textureName, true);
        key.setGenerateMips(false);
        if (envMapType == EnvMapType.CubeMap) {
            key.setTextureTypeHint(Texture.Type.CubeMap);
        }
        Texture tex = assetManager.loadTexture(key);
        return SkyFactory.createSky(assetManager, tex, envMapType);
    }

    private static void checkImage(Image image) {
        if (image.getWidth() != image.getHeight()) {
            throw new IllegalArgumentException("Image width and height must be the same");
        }
        if (image.getMultiSamples() != 1) {
            throw new IllegalArgumentException("Multisample textures not allowed");
        }
    }

    private static void checkImagesForCubeMap(Image ... images) {
        if (images.length == 1) {
            return;
        }
        Image.Format fmt = images[0].getFormat();
        int width = images[0].getWidth();
        int height = images[0].getHeight();
        ByteBuffer data = images[0].getData(0);
        int size = data != null ? data.capacity() : 0;
        SkyFactory.checkImage(images[0]);
        for (int i = 1; i < images.length; ++i) {
            Image image = images[i];
            SkyFactory.checkImage(images[i]);
            if (image.getFormat() != fmt) {
                throw new IllegalArgumentException("Images must have same format");
            }
            if (image.getWidth() != width || image.getHeight() != height) {
                throw new IllegalArgumentException("Images must have same resolution");
            }
            ByteBuffer data2 = image.getData(0);
            if (data2 == null || data2.capacity() == size) continue;
            throw new IllegalArgumentException("Images must have same size");
        }
    }

    public static Spatial createSky(AssetManager assetManager, Texture west, Texture east, Texture north, Texture south, Texture up, Texture down, Vector3f normalScale) {
        return SkyFactory.createSky(assetManager, west, east, north, south, up, down, normalScale, 10.0f);
    }

    public static Spatial createSky(AssetManager assetManager, Texture west, Texture east, Texture north, Texture south, Texture up, Texture down, Vector3f normalScale, float sphereRadius) {
        Image westImg = west.getImage();
        Image eastImg = east.getImage();
        Image northImg = north.getImage();
        Image southImg = south.getImage();
        Image upImg = up.getImage();
        Image downImg = down.getImage();
        SkyFactory.checkImagesForCubeMap(westImg, eastImg, northImg, southImg, upImg, downImg);
        Image cubeImage = new Image(westImg.getFormat(), westImg.getWidth(), westImg.getHeight(), null, westImg.getColorSpace());
        cubeImage.addData(westImg.getData(0));
        cubeImage.addData(eastImg.getData(0));
        cubeImage.addData(downImg.getData(0));
        cubeImage.addData(upImg.getData(0));
        cubeImage.addData(southImg.getData(0));
        cubeImage.addData(northImg.getData(0));
        TextureCubeMap cubeMap = new TextureCubeMap(cubeImage);
        return SkyFactory.createSky(assetManager, (Texture)cubeMap, normalScale, EnvMapType.CubeMap, sphereRadius);
    }

    public static Spatial createSky(AssetManager assetManager, Texture west, Texture east, Texture north, Texture south, Texture up, Texture down) {
        return SkyFactory.createSky(assetManager, west, east, north, south, up, down, Vector3f.UNIT_XYZ);
    }

    public static enum EnvMapType {
        CubeMap,
        SphereMap,
        EquirectMap;

    }
}

