/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.util;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MemoryUtils {
    private static MBeanServer mbeans = ManagementFactory.getPlatformMBeanServer();
    private static ObjectName directPool;

    private MemoryUtils() {
    }

    public static long getDirectMemoryUsage() {
        try {
            Long value = (Long)mbeans.getAttribute(directPool, "MemoryUsed");
            return value == null ? -1L : value;
        }
        catch (JMException ex) {
            Logger.getLogger(MemoryUtils.class.getName()).log(Level.SEVERE, "Error retrieving MemoryUsed", ex);
            return -1L;
        }
    }

    public static long getDirectMemoryCount() {
        try {
            Long value = (Long)mbeans.getAttribute(directPool, "Count");
            return value == null ? -1L : value;
        }
        catch (JMException ex) {
            Logger.getLogger(MemoryUtils.class.getName()).log(Level.SEVERE, "Error retrieving Count", ex);
            return -1L;
        }
    }

    public static long getDirectMemoryTotalCapacity() {
        try {
            Long value = (Long)mbeans.getAttribute(directPool, "TotalCapacity");
            return value == null ? -1L : value;
        }
        catch (JMException ex) {
            Logger.getLogger(MemoryUtils.class.getName()).log(Level.SEVERE, "Error retrieving TotalCapacity", ex);
            return -1L;
        }
    }

    static {
        try {
            directPool = new ObjectName("java.nio:type=BufferPool,name=direct");
        }
        catch (MalformedObjectNameException ex) {
            Logger.getLogger(MemoryUtils.class.getName()).log(Level.SEVERE, "Error creating direct pool ObjectName", ex);
        }
    }
}

