/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ColorSpace;
import java.io.IOException;

public class Texture3D
extends Texture {
    private Texture.WrapMode wrapS = Texture.WrapMode.EdgeClamp;
    private Texture.WrapMode wrapT = Texture.WrapMode.EdgeClamp;
    private Texture.WrapMode wrapR = Texture.WrapMode.EdgeClamp;

    public Texture3D() {
    }

    public Texture3D(Image img) {
        this.setImage(img);
        if (img.getFormat().isDepthFormat()) {
            this.setMagFilter(Texture.MagFilter.Nearest);
            this.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
        }
    }

    public Texture3D(int width, int height, int depth, Image.Format format) {
        this(new Image(format, width, height, depth, null, ColorSpace.Linear));
    }

    public Texture3D(int width, int height, int depth, int numSamples, Image.Format format) {
        this(new Image(format, width, height, depth, null, ColorSpace.Linear));
        this.getImage().setMultiSamples(numSamples);
    }

    @Override
    public Texture createSimpleClone() {
        Texture3D clone = new Texture3D();
        this.createSimpleClone(clone);
        return clone;
    }

    @Override
    public Texture createSimpleClone(Texture rVal) {
        rVal.setWrap(Texture.WrapAxis.S, this.wrapS);
        rVal.setWrap(Texture.WrapAxis.T, this.wrapT);
        rVal.setWrap(Texture.WrapAxis.R, this.wrapR);
        return super.createSimpleClone(rVal);
    }

    @Override
    public void setWrap(Texture.WrapAxis axis, Texture.WrapMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        if (axis == null) {
            throw new IllegalArgumentException("axis can not be null.");
        }
        switch (axis) {
            case S: {
                this.wrapS = mode;
                break;
            }
            case T: {
                this.wrapT = mode;
                break;
            }
            case R: {
                this.wrapR = mode;
            }
        }
    }

    @Override
    public void setWrap(Texture.WrapMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        this.wrapS = mode;
        this.wrapT = mode;
        this.wrapR = mode;
    }

    @Override
    public Texture.WrapMode getWrap(Texture.WrapAxis axis) {
        switch (axis) {
            case S: {
                return this.wrapS;
            }
            case T: {
                return this.wrapT;
            }
            case R: {
                return this.wrapR;
            }
        }
        throw new IllegalArgumentException("invalid WrapAxis: " + (Object)((Object)axis));
    }

    @Override
    public Texture.Type getType() {
        return Texture.Type.ThreeDimensional;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Texture3D)) {
            return false;
        }
        Texture3D that = (Texture3D)other;
        if (this.getWrap(Texture.WrapAxis.S) != that.getWrap(Texture.WrapAxis.S)) {
            return false;
        }
        if (this.getWrap(Texture.WrapAxis.T) != that.getWrap(Texture.WrapAxis.T)) {
            return false;
        }
        if (this.getWrap(Texture.WrapAxis.R) != that.getWrap(Texture.WrapAxis.R)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.wrapS, "wrapS", Texture.WrapMode.EdgeClamp);
        capsule.write(this.wrapT, "wrapT", Texture.WrapMode.EdgeClamp);
        capsule.write(this.wrapR, "wrapR", Texture.WrapMode.EdgeClamp);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule(this);
        this.wrapS = capsule.readEnum("wrapS", Texture.WrapMode.class, Texture.WrapMode.EdgeClamp);
        this.wrapT = capsule.readEnum("wrapT", Texture.WrapMode.class, Texture.WrapMode.EdgeClamp);
        this.wrapR = capsule.readEnum("wrapR", Texture.WrapMode.class, Texture.WrapMode.EdgeClamp);
    }
}

