/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.shadow.AbstractShadowRenderer;
import com.jme3.shadow.ShadowUtil;
import com.jme3.util.TempVars;
import com.jme3.util.clone.Cloner;
import java.io.IOException;

public class PointLightShadowRenderer
extends AbstractShadowRenderer {
    public static final int CAM_NUMBER = 6;
    protected PointLight light;
    protected Camera[] shadowCams;
    private Geometry[] frustums = null;

    protected PointLightShadowRenderer() {
    }

    public PointLightShadowRenderer(AssetManager assetManager, int shadowMapSize) {
        super(assetManager, shadowMapSize, 6);
        this.init(shadowMapSize);
    }

    private void init(int shadowMapSize) {
        this.shadowCams = new Camera[6];
        for (int i = 0; i < 6; ++i) {
            this.shadowCams[i] = new Camera(shadowMapSize, shadowMapSize);
        }
    }

    @Override
    protected void initFrustumCam() {
        Camera viewCam = this.viewPort.getCamera();
        this.frustumCam = viewCam.clone();
        this.frustumCam.setFrustum(viewCam.getFrustumNear(), this.zFarOverride, viewCam.getFrustumLeft(), viewCam.getFrustumRight(), viewCam.getFrustumTop(), viewCam.getFrustumBottom());
    }

    @Override
    protected void updateShadowCams(Camera viewCam) {
        if (this.light == null) {
            logger.warning("The light can't be null for a " + this.getClass().getName());
            return;
        }
        this.shadowCams[0].setAxes(Vector3f.UNIT_X.mult(-1.0f), Vector3f.UNIT_Z.mult(-1.0f), Vector3f.UNIT_Y.mult(-1.0f));
        this.shadowCams[1].setAxes(Vector3f.UNIT_X.mult(-1.0f), Vector3f.UNIT_Z, Vector3f.UNIT_Y);
        this.shadowCams[2].setAxes(Vector3f.UNIT_X.mult(-1.0f), Vector3f.UNIT_Y, Vector3f.UNIT_Z.mult(-1.0f));
        this.shadowCams[3].setAxes(Vector3f.UNIT_X, Vector3f.UNIT_Y, Vector3f.UNIT_Z);
        this.shadowCams[4].setAxes(Vector3f.UNIT_Z, Vector3f.UNIT_Y, Vector3f.UNIT_X.mult(-1.0f));
        this.shadowCams[5].setAxes(Vector3f.UNIT_Z.mult(-1.0f), Vector3f.UNIT_Y, Vector3f.UNIT_X);
        for (int i = 0; i < 6; ++i) {
            this.shadowCams[i].setFrustumPerspective(90.0f, 1.0f, 0.1f, this.light.getRadius());
            this.shadowCams[i].setLocation(this.light.getPosition());
            this.shadowCams[i].update();
            this.shadowCams[i].updateViewProjection();
        }
    }

    @Override
    protected GeometryList getOccludersToRender(int shadowMapIndex, GeometryList shadowMapOccluders) {
        for (Spatial scene : this.viewPort.getScenes()) {
            ShadowUtil.getGeometriesInCamFrustum(scene, this.shadowCams[shadowMapIndex], RenderQueue.ShadowMode.Cast, shadowMapOccluders);
        }
        return shadowMapOccluders;
    }

    @Override
    protected void getReceivers(GeometryList lightReceivers) {
        lightReceivers.clear();
        for (Spatial scene : this.viewPort.getScenes()) {
            ShadowUtil.getLitGeometriesInViewPort(scene, this.viewPort.getCamera(), this.shadowCams, RenderQueue.ShadowMode.Receive, lightReceivers);
        }
    }

    @Override
    protected Camera getShadowCam(int shadowMapIndex) {
        return this.shadowCams[shadowMapIndex];
    }

    @Override
    protected void doDisplayFrustumDebug(int shadowMapIndex) {
        if (this.frustums == null) {
            int i;
            this.frustums = new Geometry[6];
            Vector3f[] points = new Vector3f[8];
            for (i = 0; i < 8; ++i) {
                points[i] = new Vector3f();
            }
            for (i = 0; i < 6; ++i) {
                ShadowUtil.updateFrustumPoints2(this.shadowCams[i], points);
                this.frustums[i] = this.createFrustum(points, i);
            }
        }
        if (this.frustums[shadowMapIndex].getParent() == null) {
            ((Node)this.viewPort.getScenes().get(0)).attachChild(this.frustums[shadowMapIndex]);
        }
    }

    @Override
    protected void setMaterialParameters(Material material) {
        material.setVector3("LightPos", this.light == null ? new Vector3f() : this.light.getPosition());
    }

    @Override
    protected void clearMaterialParameters(Material material) {
        material.clearParam("LightPos");
    }

    public PointLight getLight() {
        return this.light;
    }

    public void setLight(PointLight light) {
        this.light = light;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.light = cloner.clone(this.light);
        this.init((int)this.shadowMapSize);
        this.frustums = null;
        super.cloneFields(cloner, original);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.light = (PointLight)ic.readSavable("light", null);
        this.init((int)this.shadowMapSize);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.light, "light", null);
    }

    @Override
    protected boolean checkCulling(Camera viewCam) {
        if (this.light == null) {
            return false;
        }
        Camera cam = viewCam;
        if (this.frustumCam != null) {
            cam = this.frustumCam;
            cam.setLocation(viewCam.getLocation());
            cam.setRotation(viewCam.getRotation());
        }
        TempVars vars = TempVars.get();
        boolean intersects = this.light.intersectsFrustum(cam, vars);
        vars.release();
        return intersects;
    }
}

