/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.light.LightFilter;
import com.jme3.light.NullLightFilter;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.OpaqueComparator;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.WireFrustum;
import com.jme3.shadow.CompareMode;
import com.jme3.shadow.EdgeFilteringMode;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractShadowRenderer
implements SceneProcessor,
Savable,
JmeCloneable,
Cloneable {
    protected static final Logger logger = Logger.getLogger(AbstractShadowRenderer.class.getName());
    private static final LightFilter NULL_LIGHT_FILTER = new NullLightFilter();
    protected int nbShadowMaps = 1;
    protected float shadowMapSize;
    protected float shadowIntensity = 0.7f;
    protected RenderManager renderManager;
    protected ViewPort viewPort;
    protected FrameBuffer[] shadowFB;
    protected Texture2D[] shadowMaps;
    protected Texture2D dummyTex;
    protected Material preshadowMat;
    protected Material postshadowMat;
    protected Matrix4f[] lightViewProjectionsMatrices;
    protected AssetManager assetManager;
    protected boolean debug = false;
    protected float edgesThickness = 1.0f;
    protected EdgeFilteringMode edgeFilteringMode = EdgeFilteringMode.Bilinear;
    protected CompareMode shadowCompareMode = CompareMode.Hardware;
    protected Picture[] dispPic;
    protected RenderState forcedRenderState = new RenderState();
    protected boolean renderBackFacesShadows = true;
    protected AppProfiler prof;
    protected boolean needsfallBackMaterial = false;
    protected String postTechniqueName = "PostShadow";
    protected List<Material> matCache = new ArrayList<Material>();
    protected GeometryList lightReceivers = new GeometryList(new OpaqueComparator());
    protected GeometryList shadowMapOccluders = new GeometryList(new OpaqueComparator());
    private String[] shadowMapStringCache;
    private String[] lightViewStringCache;
    protected float zFarOverride = 0.0f;
    protected Vector2f fadeInfo;
    protected float fadeLength;
    protected Camera frustumCam;
    protected boolean skipPostPass;
    boolean debugfrustums = false;

    protected AbstractShadowRenderer() {
    }

    protected AbstractShadowRenderer(AssetManager assetManager, int shadowMapSize, int nbShadowMaps) {
        this.assetManager = assetManager;
        this.nbShadowMaps = nbShadowMaps;
        this.shadowMapSize = shadowMapSize;
        this.init(assetManager, nbShadowMaps, shadowMapSize);
    }

    private void init(AssetManager assetManager, int nbShadowMaps, int shadowMapSize) {
        this.postshadowMat = new Material(assetManager, "Common/MatDefs/Shadow/PostShadow.j3md");
        this.shadowFB = new FrameBuffer[nbShadowMaps];
        this.shadowMaps = new Texture2D[nbShadowMaps];
        this.dispPic = new Picture[nbShadowMaps];
        this.lightViewProjectionsMatrices = new Matrix4f[nbShadowMaps];
        this.shadowMapStringCache = new String[nbShadowMaps];
        this.lightViewStringCache = new String[nbShadowMaps];
        this.dummyTex = new Texture2D(shadowMapSize, shadowMapSize, Image.Format.RGBA8);
        this.preshadowMat = new Material(assetManager, "Common/MatDefs/Shadow/PreShadow.j3md");
        this.postshadowMat.setFloat("ShadowMapSize", shadowMapSize);
        for (int i = 0; i < nbShadowMaps; ++i) {
            this.lightViewProjectionsMatrices[i] = new Matrix4f();
            this.shadowFB[i] = new FrameBuffer(shadowMapSize, shadowMapSize, 1);
            this.shadowMaps[i] = new Texture2D(shadowMapSize, shadowMapSize, Image.Format.Depth);
            this.shadowFB[i].setDepthTarget(FrameBuffer.FrameBufferTarget.newTarget(this.shadowMaps[i]));
            this.shadowFB[i].addColorTarget(FrameBuffer.FrameBufferTarget.newTarget(this.dummyTex));
            this.shadowMapStringCache[i] = "ShadowMap" + i;
            this.lightViewStringCache[i] = "LightViewProjectionMatrix" + i;
            this.postshadowMat.setTexture(this.shadowMapStringCache[i], this.shadowMaps[i]);
            this.dispPic[i] = new Picture("Picture" + i);
            this.dispPic[i].setTexture(assetManager, this.shadowMaps[i], false);
        }
        this.setShadowCompareMode(this.shadowCompareMode);
        this.setEdgeFilteringMode(this.edgeFilteringMode);
        this.setShadowIntensity(this.shadowIntensity);
        this.initForcedRenderState();
        this.setRenderBackFacesShadows(this.isRenderBackFacesShadows());
    }

    protected void initForcedRenderState() {
        this.forcedRenderState.setFaceCullMode(RenderState.FaceCullMode.Front);
        this.forcedRenderState.setColorWrite(false);
        this.forcedRenderState.setDepthWrite(true);
        this.forcedRenderState.setDepthTest(true);
    }

    protected final void setPostShadowMaterial(Material postShadowMat) {
        this.postshadowMat = postShadowMat;
        this.postshadowMat.setFloat("ShadowMapSize", this.shadowMapSize);
        for (int i = 0; i < this.nbShadowMaps; ++i) {
            this.postshadowMat.setTexture(this.shadowMapStringCache[i], this.shadowMaps[i]);
        }
        this.setShadowCompareMode(this.shadowCompareMode);
        this.setEdgeFilteringMode(this.edgeFilteringMode);
        this.setShadowIntensity(this.shadowIntensity);
    }

    public final void setEdgeFilteringMode(EdgeFilteringMode filterMode) {
        if (filterMode == null) {
            throw new IllegalArgumentException("filterMode cannot be null");
        }
        this.edgeFilteringMode = filterMode;
        this.postshadowMat.setInt("FilterMode", filterMode.getMaterialParamValue());
        this.postshadowMat.setFloat("PCFEdge", this.edgesThickness);
        if (this.shadowCompareMode == CompareMode.Hardware) {
            for (Texture2D shadowMap : this.shadowMaps) {
                if (filterMode == EdgeFilteringMode.Bilinear) {
                    shadowMap.setMagFilter(Texture.MagFilter.Bilinear);
                    shadowMap.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                    continue;
                }
                shadowMap.setMagFilter(Texture.MagFilter.Nearest);
                shadowMap.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
            }
        }
    }

    public EdgeFilteringMode getEdgeFilteringMode() {
        return this.edgeFilteringMode;
    }

    public final void setShadowCompareMode(CompareMode compareMode) {
        if (compareMode == null) {
            throw new IllegalArgumentException("Shadow compare mode cannot be null");
        }
        this.shadowCompareMode = compareMode;
        for (Texture2D shadowMap : this.shadowMaps) {
            if (compareMode == CompareMode.Hardware) {
                shadowMap.setShadowCompareMode(Texture.ShadowCompareMode.LessOrEqual);
                if (this.edgeFilteringMode == EdgeFilteringMode.Bilinear) {
                    shadowMap.setMagFilter(Texture.MagFilter.Bilinear);
                    shadowMap.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                    continue;
                }
                shadowMap.setMagFilter(Texture.MagFilter.Nearest);
                shadowMap.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
                continue;
            }
            shadowMap.setShadowCompareMode(Texture.ShadowCompareMode.Off);
            shadowMap.setMagFilter(Texture.MagFilter.Nearest);
            shadowMap.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
        }
        this.postshadowMat.setBoolean("HardwareShadows", compareMode == CompareMode.Hardware);
    }

    public CompareMode getShadowCompareMode() {
        return this.shadowCompareMode;
    }

    protected Geometry createFrustum(Vector3f[] pts, int i) {
        WireFrustum frustum = new WireFrustum(pts);
        Geometry frustumMdl = new Geometry("f", frustum);
        frustumMdl.setCullHint(Spatial.CullHint.Never);
        frustumMdl.setShadowMode(RenderQueue.ShadowMode.Off);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        frustumMdl.setMaterial(mat);
        switch (i) {
            case 0: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.Pink);
                break;
            }
            case 1: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.Red);
                break;
            }
            case 2: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.Green);
                break;
            }
            case 3: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.Blue);
                break;
            }
            default: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.White);
            }
        }
        frustumMdl.updateGeometricState();
        return frustumMdl;
    }

    @Override
    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
        this.viewPort = vp;
        this.postTechniqueName = "PostShadow";
        if (this.zFarOverride > 0.0f && this.frustumCam == null) {
            this.initFrustumCam();
        }
    }

    protected abstract void initFrustumCam();

    @Override
    public boolean isInitialized() {
        return this.viewPort != null;
    }

    protected abstract void updateShadowCams(Camera var1);

    protected abstract GeometryList getOccludersToRender(int var1, GeometryList var2);

    protected abstract Camera getShadowCam(int var1);

    protected void doDisplayFrustumDebug(int shadowMapIndex) {
    }

    @Override
    public void postQueue(RenderQueue rq) {
        this.lightReceivers.clear();
        this.skipPostPass = false;
        if (!this.checkCulling(this.viewPort.getCamera())) {
            this.skipPostPass = true;
            return;
        }
        this.updateShadowCams(this.viewPort.getCamera());
        Renderer r = this.renderManager.getRenderer();
        this.renderManager.setForcedMaterial(this.preshadowMat);
        this.renderManager.setForcedTechnique("PreShadow");
        for (int shadowMapIndex = 0; shadowMapIndex < this.nbShadowMaps; ++shadowMapIndex) {
            if (this.debugfrustums) {
                this.doDisplayFrustumDebug(shadowMapIndex);
            }
            this.renderShadowMap(shadowMapIndex);
        }
        this.debugfrustums = false;
        r.setFrameBuffer(this.viewPort.getOutputFrameBuffer());
        this.renderManager.setForcedMaterial(null);
        this.renderManager.setForcedTechnique(null);
        this.renderManager.setCamera(this.viewPort.getCamera(), false);
    }

    protected void renderShadowMap(int shadowMapIndex) {
        this.shadowMapOccluders = this.getOccludersToRender(shadowMapIndex, this.shadowMapOccluders);
        Camera shadowCam = this.getShadowCam(shadowMapIndex);
        this.lightViewProjectionsMatrices[shadowMapIndex].set(shadowCam.getViewProjectionMatrix());
        this.renderManager.setCamera(shadowCam, false);
        this.renderManager.getRenderer().setFrameBuffer(this.shadowFB[shadowMapIndex]);
        this.renderManager.getRenderer().clearBuffers(true, true, true);
        this.renderManager.setForcedRenderState(this.forcedRenderState);
        LightFilter tmpLightFilter = this.renderManager.getLightFilter();
        this.renderManager.setLightFilter(NULL_LIGHT_FILTER);
        this.viewPort.getQueue().renderShadowQueue(this.shadowMapOccluders, this.renderManager, shadowCam, true);
        this.renderManager.setLightFilter(tmpLightFilter);
        this.renderManager.setForcedRenderState(null);
    }

    public void displayFrustum() {
        this.debugfrustums = true;
    }

    protected void displayShadowMap(Renderer r) {
        Camera cam = this.viewPort.getCamera();
        this.renderManager.setCamera(cam, true);
        int h = cam.getHeight();
        for (int i = 0; i < this.dispPic.length; ++i) {
            this.dispPic[i].setPosition(128 * i + (150 + 64 * (i + 1)), (float)h / 20.0f);
            this.dispPic[i].setWidth(128.0f);
            this.dispPic[i].setHeight(128.0f);
            this.dispPic[i].updateGeometricState();
            this.renderManager.renderGeometry(this.dispPic[i]);
        }
        this.renderManager.setCamera(cam, false);
    }

    public void displayDebug() {
        this.debug = true;
    }

    protected abstract void getReceivers(GeometryList var1);

    @Override
    public void postFrame(FrameBuffer out) {
        if (this.skipPostPass) {
            return;
        }
        if (this.debug) {
            this.displayShadowMap(this.renderManager.getRenderer());
        }
        this.getReceivers(this.lightReceivers);
        if (this.lightReceivers.size() != 0) {
            this.setMatParams(this.lightReceivers);
            Camera cam = this.viewPort.getCamera();
            if (this.needsfallBackMaterial) {
                this.renderManager.setForcedMaterial(this.postshadowMat);
            }
            this.renderManager.setForcedTechnique(this.postTechniqueName);
            this.viewPort.getQueue().renderShadowQueue(this.lightReceivers, this.renderManager, cam, false);
            this.renderManager.setForcedTechnique(null);
            this.renderManager.setForcedMaterial(null);
            this.renderManager.setCamera(cam, false);
            this.clearMatParams();
        }
    }

    protected abstract void clearMaterialParameters(Material var1);

    private void clearMatParams() {
        for (Material mat : this.matCache) {
            int j;
            for (j = 1; j < this.nbShadowMaps; ++j) {
                mat.clearParam(this.lightViewStringCache[j]);
            }
            for (j = 1; j < this.nbShadowMaps; ++j) {
                mat.clearParam(this.shadowMapStringCache[j]);
            }
            mat.clearParam("FadeInfo");
            this.clearMaterialParameters(mat);
        }
    }

    protected abstract void setMaterialParameters(Material var1);

    private void setMatParams(GeometryList l) {
        this.buildMatCache(l);
        for (Material mat : this.matCache) {
            int j;
            mat.setFloat("ShadowMapSize", this.shadowMapSize);
            for (j = 0; j < this.nbShadowMaps; ++j) {
                mat.setMatrix4(this.lightViewStringCache[j], this.lightViewProjectionsMatrices[j]);
            }
            for (j = 0; j < this.nbShadowMaps; ++j) {
                mat.setTexture(this.shadowMapStringCache[j], this.shadowMaps[j]);
            }
            mat.setBoolean("HardwareShadows", this.shadowCompareMode == CompareMode.Hardware);
            mat.setInt("FilterMode", this.edgeFilteringMode.getMaterialParamValue());
            mat.setFloat("PCFEdge", this.edgesThickness);
            mat.setFloat("ShadowIntensity", this.shadowIntensity);
            mat.setBoolean("BackfaceShadows", this.renderBackFacesShadows);
            if (this.fadeInfo != null) {
                mat.setVector2("FadeInfo", this.fadeInfo);
            }
            this.setMaterialParameters(mat);
        }
        if (this.needsfallBackMaterial) {
            this.setPostShadowParams();
        }
    }

    private void buildMatCache(GeometryList l) {
        this.matCache.clear();
        for (int i = 0; i < l.size(); ++i) {
            Material mat = l.get(i).getMaterial();
            if (mat.getMaterialDef().getTechniqueDefs(this.postTechniqueName) != null) {
                if (this.matCache.contains(mat)) continue;
                this.matCache.add(mat);
                continue;
            }
            this.needsfallBackMaterial = true;
        }
    }

    protected void setPostShadowParams() {
        this.setMaterialParameters(this.postshadowMat);
        for (int j = 0; j < this.nbShadowMaps; ++j) {
            this.postshadowMat.setMatrix4(this.lightViewStringCache[j], this.lightViewProjectionsMatrices[j]);
            this.postshadowMat.setTexture(this.shadowMapStringCache[j], this.shadowMaps[j]);
        }
        if (this.fadeInfo != null) {
            this.postshadowMat.setVector2("FadeInfo", this.fadeInfo);
        }
        this.postshadowMat.setBoolean("BackfaceShadows", this.renderBackFacesShadows);
    }

    public float getShadowZExtend() {
        return this.zFarOverride;
    }

    public void setShadowZExtend(float zFar) {
        this.zFarOverride = zFar;
        if (this.zFarOverride == 0.0f) {
            this.fadeInfo = null;
            this.frustumCam = null;
        } else {
            if (this.fadeInfo != null) {
                this.fadeInfo.set(this.zFarOverride - this.fadeLength, 1.0f / this.fadeLength);
            }
            if (this.frustumCam == null && this.viewPort != null) {
                this.initFrustumCam();
            }
        }
    }

    public void setShadowZFadeLength(float length) {
        if (length == 0.0f) {
            this.fadeInfo = null;
            this.fadeLength = 0.0f;
            this.postshadowMat.clearParam("FadeInfo");
        } else {
            this.fadeInfo = this.zFarOverride == 0.0f ? new Vector2f(0.0f, 0.0f) : new Vector2f(this.zFarOverride - length, 1.0f / length);
            this.fadeLength = length;
            this.postshadowMat.setVector2("FadeInfo", this.fadeInfo);
        }
    }

    public float getShadowZFadeLength() {
        if (this.fadeInfo != null) {
            return this.zFarOverride - this.fadeInfo.x;
        }
        return 0.0f;
    }

    protected abstract boolean checkCulling(Camera var1);

    @Override
    public void preFrame(float tpf) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void reshape(ViewPort vp, int w, int h) {
    }

    public float getShadowIntensity() {
        return this.shadowIntensity;
    }

    public final void setShadowIntensity(float shadowIntensity) {
        this.shadowIntensity = shadowIntensity;
        this.postshadowMat.setFloat("ShadowIntensity", shadowIntensity);
    }

    public int getEdgesThickness() {
        return (int)(this.edgesThickness * 10.0f);
    }

    public int getNumShadowMaps() {
        return this.nbShadowMaps;
    }

    public int getShadowMapSize() {
        return (int)this.shadowMapSize;
    }

    public void setEdgesThickness(int edgesThickness) {
        this.edgesThickness = Math.max(1, Math.min(edgesThickness, 10));
        this.edgesThickness *= 0.1f;
        this.postshadowMat.setFloat("PCFEdge", this.edgesThickness);
    }

    @Deprecated
    public boolean isFlushQueues() {
        return false;
    }

    public RenderState getPreShadowForcedRenderState() {
        return this.forcedRenderState;
    }

    public void setRenderBackFacesShadows(boolean renderBackFacesShadows) {
        this.renderBackFacesShadows = renderBackFacesShadows;
        if (renderBackFacesShadows) {
            this.getPreShadowForcedRenderState().setPolyOffset(5.0f, 3.0f);
            this.getPreShadowForcedRenderState().setFaceCullMode(RenderState.FaceCullMode.Back);
        } else {
            this.getPreShadowForcedRenderState().setPolyOffset(0.0f, 0.0f);
            this.getPreShadowForcedRenderState().setFaceCullMode(RenderState.FaceCullMode.Front);
        }
    }

    public boolean isRenderBackFacesShadows() {
        return this.renderBackFacesShadows;
    }

    @Override
    public Object jmeClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        this.forcedRenderState = cloner.clone(this.forcedRenderState);
        this.init(this.assetManager, this.nbShadowMaps, (int)this.shadowMapSize);
    }

    @Override
    public void setProfiler(AppProfiler profiler) {
        this.prof = profiler;
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.assetManager = im.getAssetManager();
        this.nbShadowMaps = ic.readInt("nbShadowMaps", 1);
        this.shadowMapSize = ic.readFloat("shadowMapSize", 0.0f);
        this.shadowIntensity = ic.readFloat("shadowIntensity", 0.7f);
        this.edgeFilteringMode = ic.readEnum("edgeFilteringMode", EdgeFilteringMode.class, EdgeFilteringMode.Bilinear);
        this.shadowCompareMode = ic.readEnum("shadowCompareMode", CompareMode.class, CompareMode.Hardware);
        this.init(this.assetManager, this.nbShadowMaps, (int)this.shadowMapSize);
        this.edgesThickness = ic.readFloat("edgesThickness", 1.0f);
        this.postshadowMat.setFloat("PCFEdge", this.edgesThickness);
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.nbShadowMaps, "nbShadowMaps", 1);
        oc.write(this.shadowMapSize, "shadowMapSize", 0.0f);
        oc.write(this.shadowIntensity, "shadowIntensity", 0.7f);
        oc.write(this.edgeFilteringMode, "edgeFilteringMode", EdgeFilteringMode.Bilinear);
        oc.write(this.shadowCompareMode, "shadowCompareMode", CompareMode.Hardware);
        oc.write(this.edgesThickness, "edgesThickness", 1.0f);
    }
}

