/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader.bufferobject.layout;

import com.jme3.math.FastMath;
import com.jme3.util.functional.Function;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class BufferLayout {
    protected List<ObjectSerializer<?>> serializers = new ArrayList();

    protected ObjectSerializer<?> getSerializer(Object obj) {
        for (int i = this.serializers.size() - 1; i >= 0; --i) {
            ObjectSerializer<?> sr = this.serializers.get(i);
            if (!sr.canSerialize(obj)) continue;
            return sr;
        }
        throw new RuntimeException("Serializer not found for " + obj + " of type " + obj.getClass());
    }

    protected void registerSerializer(ObjectSerializer<?> serializer) {
        this.serializers.add(serializer);
    }

    public int estimateSize(Object o) {
        ObjectSerializer<?> s = this.getSerializer(o);
        return s.length(this, o);
    }

    public int getBasicAlignment(Object o) {
        ObjectSerializer<?> s = this.getSerializer(o);
        return s.basicAlignment(this, o);
    }

    public int align(int pos, int basicAlignment) {
        return pos == 0 ? pos : FastMath.toMultipleOf(pos, basicAlignment);
    }

    public void write(ByteBuffer out, Object o) {
        ObjectSerializer<?> s = this.getSerializer(o);
        s.write(this, out, o);
    }

    public abstract String getId();

    public static abstract class ObjectSerializer<T> {
        private Function<Boolean, Object> filter;

        public ObjectSerializer(Class<T> cls) {
            this((Object obj) -> {
                Class<?> objc = obj instanceof Class ? (Class<?>)obj : obj.getClass();
                return cls.isAssignableFrom(objc);
            });
        }

        public ObjectSerializer(Function<Boolean, Object> filter) {
            this.filter = filter;
        }

        public final boolean canSerialize(Object obj) {
            return this.filter.eval(obj);
        }

        public abstract int length(BufferLayout var1, T var2);

        public abstract int basicAlignment(BufferLayout var1, T var2);

        public abstract void write(BufferLayout var1, ByteBuffer var2, T var3);
    }
}

