/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix3f;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.shader.bufferobject.BufferObject;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.Texture3D;
import com.jme3.texture.TextureArray;
import com.jme3.texture.TextureCubeMap;
import com.jme3.texture.TextureImage;

public enum VarType {
    Float("float", java.lang.Float.TYPE, Float.class),
    Vector2("vec2", Vector2f.class),
    Vector3("vec3", Vector3f.class),
    Vector4("vec4", Vector4f.class, ColorRGBA.class),
    IntArray(true, false, "int", int[].class, Integer[].class),
    FloatArray(true, false, "float", float[].class, Float[].class),
    Vector2Array(true, false, "vec2", Vector2f[].class),
    Vector3Array(true, false, "vec3", Vector3f[].class),
    Vector4Array(true, false, "vec4", Vector4f[].class),
    Int("int", Integer.TYPE, Integer.class),
    Boolean("bool", Boolean.class, java.lang.Boolean.TYPE),
    Matrix3(true, false, "mat3", Matrix3f.class),
    Matrix4(true, false, "mat4", Matrix4f.class),
    Matrix3Array(true, false, "mat3", Matrix3f[].class),
    Matrix4Array(true, false, "mat4", Matrix4f[].class),
    TextureBuffer(false, true, "sampler1D|sampler1DShadow", new Class[0]),
    Texture2D(false, true, "sampler2D|sampler2DShadow", Texture2D.class, Texture.class),
    Texture3D(false, true, "sampler3D", Texture3D.class, Texture.class),
    TextureArray(false, true, "sampler2DArray|sampler2DArrayShadow", TextureArray.class, Texture.class),
    TextureCubeMap(false, true, "samplerCube", TextureCubeMap.class, Texture.class),
    Image2D(false, false, true, "image2D", TextureImage.class),
    Image3D(false, false, true, "image3D", TextureImage.class),
    UniformBufferObject(false, false, "custom", BufferObject.class),
    ShaderStorageBufferObject(false, false, "custom", BufferObject.class);

    private boolean usesMultiData = false;
    private boolean textureType = false;
    private boolean imageType = false;
    private final String glslType;
    private Class<?>[] javaTypes;

    private VarType(String glslType, Class<?> ... javaTypes) {
        this.glslType = glslType;
        this.javaTypes = javaTypes != null ? javaTypes : new Class[0];
    }

    private VarType(boolean multiData, boolean textureType, String glslType, Class<?> ... javaTypes) {
        this.usesMultiData = multiData;
        this.textureType = textureType;
        this.glslType = glslType;
        this.javaTypes = javaTypes != null ? javaTypes : new Class[0];
    }

    private VarType(boolean multiData, boolean textureType, boolean imageType, String glslType, Class<?> ... javaTypes) {
        this(multiData, textureType, glslType, javaTypes);
        this.imageType = imageType;
    }

    public boolean isOfType(Object o) {
        for (Class<?> c : this.javaTypes) {
            if (!c.isAssignableFrom(o.getClass())) continue;
            return true;
        }
        return false;
    }

    public Class<?>[] getJavaType() {
        return this.javaTypes;
    }

    public boolean isTextureType() {
        return this.textureType;
    }

    public boolean isImageType() {
        return this.imageType;
    }

    public boolean usesMultiData() {
        return this.usesMultiData;
    }

    public String getGlslType() {
        return this.glslType;
    }
}

