/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.renderer.Renderer;
import com.jme3.scene.VertexBuffer;
import com.jme3.shader.Attribute;
import com.jme3.shader.ShaderBufferBlock;
import com.jme3.shader.Uniform;
import com.jme3.shader.UniformBinding;
import com.jme3.util.IntMap;
import com.jme3.util.ListMap;
import com.jme3.util.NativeObject;
import java.util.ArrayList;
import java.util.Collection;

public final class Shader
extends NativeObject {
    private final ArrayList<ShaderSource> shaderSourceList = new ArrayList();
    private final ListMap<String, Uniform> uniforms;
    private final ListMap<String, ShaderBufferBlock> bufferBlocks;
    private final ArrayList<Uniform> boundUniforms;
    private final IntMap<Attribute> attribs;

    public Shader() {
        this.uniforms = new ListMap();
        this.bufferBlocks = new ListMap();
        this.attribs = new IntMap();
        this.boundUniforms = new ArrayList();
    }

    protected Shader(Shader s) {
        super(s.id);
        for (ShaderSource source : s.shaderSourceList) {
            this.shaderSourceList.add((ShaderSource)source.createDestructableClone());
        }
        this.uniforms = null;
        this.bufferBlocks = null;
        this.boundUniforms = null;
        this.attribs = null;
    }

    public void addSource(ShaderType type, String name, String source, String defines, String language) {
        ShaderSource shaderSource = new ShaderSource(type);
        shaderSource.setSource(source);
        shaderSource.setName(name);
        shaderSource.setLanguage(language);
        if (defines != null) {
            shaderSource.setDefines(defines);
        }
        this.shaderSourceList.add(shaderSource);
        this.setUpdateNeeded();
    }

    public void addUniformBinding(UniformBinding binding) {
        String uniformName = "g_" + binding.name();
        Uniform uniform = this.uniforms.get(uniformName);
        if (uniform == null) {
            uniform = new Uniform();
            uniform.name = uniformName;
            uniform.binding = binding;
            this.uniforms.put(uniformName, uniform);
            this.boundUniforms.add(uniform);
        }
    }

    public Uniform getUniform(String name) {
        assert (name.startsWith("m_") || name.startsWith("g_"));
        Uniform uniform = this.uniforms.get(name);
        if (uniform == null) {
            uniform = new Uniform();
            uniform.name = name;
            this.uniforms.put(name, uniform);
        }
        return uniform;
    }

    public ShaderBufferBlock getBufferBlock(String name) {
        assert (name.startsWith("m_"));
        ShaderBufferBlock block = this.bufferBlocks.get(name);
        if (block == null) {
            block = new ShaderBufferBlock();
            block.name = name;
            this.bufferBlocks.put(name, block);
        }
        return block;
    }

    public void removeUniform(String name) {
        this.uniforms.remove(name);
    }

    public void removeBufferBlock(String name) {
        this.bufferBlocks.remove(name);
    }

    public Attribute getAttribute(VertexBuffer.Type attribType) {
        int ordinal = attribType.ordinal();
        Attribute attrib = this.attribs.get(ordinal);
        if (attrib == null) {
            attrib = new Attribute();
            attrib.name = attribType.name();
            this.attribs.put(ordinal, attrib);
        }
        return attrib;
    }

    public ListMap<String, Uniform> getUniformMap() {
        return this.uniforms;
    }

    public ListMap<String, ShaderBufferBlock> getBufferBlockMap() {
        return this.bufferBlocks;
    }

    public ArrayList<Uniform> getBoundUniforms() {
        return this.boundUniforms;
    }

    public Collection<ShaderSource> getSources() {
        return this.shaderSourceList;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[numSources=" + this.shaderSourceList.size() + ", numUniforms=" + this.uniforms.size() + ", numBufferBlocks=" + this.bufferBlocks.size() + ", shaderSources=" + this.getSources() + "]";
    }

    public void clearUniformsSetByCurrentFlag() {
        int size = this.uniforms.size();
        for (int i = 0; i < size; ++i) {
            Uniform u = this.uniforms.getValue(i);
            u.clearSetByCurrentMaterial();
        }
    }

    public void resetUniformsNotSetByCurrent() {
        int size = this.uniforms.size();
        for (int i = 0; i < size; ++i) {
            Uniform u = this.uniforms.getValue(i);
            if (u.isSetByCurrentMaterial()) continue;
            u.clearValue();
        }
    }

    public void resetLocations() {
        if (this.uniforms != null) {
            for (Uniform uniform : this.uniforms.values()) {
                uniform.reset();
            }
        }
        if (this.bufferBlocks != null) {
            for (ShaderBufferBlock shaderBufferBlock : this.bufferBlocks.values()) {
                shaderBufferBlock.reset();
            }
        }
        if (this.attribs != null) {
            for (IntMap.Entry entry : this.attribs) {
                ((Attribute)entry.getValue()).location = -2;
            }
        }
    }

    @Override
    public void setUpdateNeeded() {
        super.setUpdateNeeded();
        this.resetLocations();
    }

    @Override
    public void resetObject() {
        this.id = -1;
        for (ShaderSource source : this.shaderSourceList) {
            source.resetObject();
        }
        this.setUpdateNeeded();
    }

    @Override
    public void deleteObject(Object rendererObject) {
        ((Renderer)rendererObject).deleteShader(this);
    }

    @Override
    public NativeObject createDestructableClone() {
        return new Shader(this);
    }

    @Override
    public long getUniqueId() {
        return 0x400000000L | 0xFFFFFFFFL & (long)this.id;
    }

    public static class ShaderSource
    extends NativeObject {
        ShaderType sourceType;
        String language;
        String name;
        String source;
        String defines;

        public ShaderSource(ShaderType type) {
            this.sourceType = type;
            if (type == null) {
                throw new IllegalArgumentException("The shader type must be specified");
            }
        }

        protected ShaderSource(ShaderSource ss) {
            super(ss.id);
        }

        public ShaderSource() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ShaderType getType() {
            return this.sourceType;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            if (language == null) {
                throw new IllegalArgumentException("Shader language cannot be null");
            }
            this.language = language;
            this.setUpdateNeeded();
        }

        public void setSource(String source) {
            if (source == null) {
                throw new IllegalArgumentException("Shader source cannot be null");
            }
            this.source = source;
            this.setUpdateNeeded();
        }

        public void setDefines(String defines) {
            if (defines == null) {
                throw new IllegalArgumentException("Shader defines cannot be null");
            }
            this.defines = defines;
            this.setUpdateNeeded();
        }

        public String getSource() {
            return this.source;
        }

        public String getDefines() {
            return this.defines;
        }

        @Override
        public long getUniqueId() {
            return 0x500000000L | 0xFFFFFFFFL & (long)this.id;
        }

        @Override
        public String toString() {
            String nameTxt = "";
            if (this.name != null) {
                nameTxt = "name=" + this.name + ", ";
            }
            if (this.defines != null) {
                nameTxt = nameTxt + "defines, ";
            }
            return this.getClass().getSimpleName() + "[" + nameTxt + "type=" + this.sourceType.name() + ", language=" + this.language + "]";
        }

        @Override
        public void resetObject() {
            this.id = -1;
            this.setUpdateNeeded();
        }

        @Override
        public void deleteObject(Object rendererObject) {
            ((Renderer)rendererObject).deleteShaderSource(this);
        }

        @Override
        public NativeObject createDestructableClone() {
            return new ShaderSource(this);
        }
    }

    public static enum ShaderType {
        Fragment("frag"),
        Vertex("vert"),
        Geometry("geom"),
        TessellationControl("tsctrl"),
        TessellationEvaluation("tseval");

        private String extension;

        public String getExtension() {
            return this.extension;
        }

        private ShaderType(String extension) {
            this.extension = extension;
        }
    }
}

